/* $Id: etherlocal.c,v 2.1 89/10/23 15:42:38 dupuy Exp $ */

#include <sys/types.h>			/* (u_char) */
#include <sys/socket.h>			/* sockaddr_in (sockaddr) */
#include <net/if.h>			/* ifconf */
#include <netinet/in.h>			/* sockaddr_in */
#include <errno.h>

extern int errno;

#include "libether.h"

extern short _ether_ifindex[MAXNUMIF];	/* from ether_interfaces() */
extern struct ifconf _ether_ifconf;	/* from ether_interfaces() */


int
_ether_localif (addr, ipaddr)
ether_addr *addr;
struct in_addr *ipaddr;
{
    char **intfs;
    int i;

    if ((intfs = ether_interfaces ()) == 0)
	return (0);

    for (i = 0; *intfs; intfs++, i++)
    {
	ether_addr eaddr;

	if (_ether_ifindex[i] < 0)
	    continue;			/* not an AF_INET interface */

	if (ether_intfaddr (*intfs, &eaddr) == 0)
	    return (0);

	if (ether_cmp (addr, &eaddr) == 0)
	{
	    struct sockaddr_in *inaddr;

	    inaddr = (struct sockaddr_in *)
		&_ether_ifconf.ifc_req[_ether_ifindex[i]].ifr_addr;

	    (void) bcopy ((char *) &inaddr->sin_addr, (char *) ipaddr,
			  sizeof (*ipaddr));
	    return (1);
	}
    }

    return (0);				/* doesn't match any local interface */
}
