/* $Id: dliself.c,v 2.0 89/10/20 19:01:55 dupuy Exp $ */

#include <sys/param.h>			/* NOFILE */
#include <sys/socket.h>			/* sockaddr_dl (sockaddr) */

#include <net/if.h>			/* (ether_header) (ifnet) */
#include <netinet/in.h>			/* (ether_header) (in_addr) */
#include <netinet/if_ether.h>		/* sockaddr_dl (ether_header) */
#include <netdnet/dli_var.h>		/* sockaddr_dl */

extern struct sockaddr_dl _ether_sockaddrs[NOFILE];

#define sad (_ether_sockaddrs[fd])

/*
 * Most, but not all, VAX interfaces, loopback packets.	 The Ultrix drivers
 * for the rest try (with varying degrees of success) to compensate for that
 * as far as broadcast packets go.  The ec (3com) driver does it only for IP
 * packets, and does not support multicast, and seems to be unsupported by
 * DEC.
 */

static char *softloops[] = {"ec", "qe", "se"};

int
ether_send_self (fd)
int fd;
{
    unsigned char *devname = sad.dli_device.dli_devname;
    int i;

    for (i = 0; i < sizeof (softloops) / sizeof (softloops[0]); i++)
	if (!strcmp ((char *) devname, softloops[i]))
	    return (0);

    return (1);				/* default to true */
}

int
ether_mcast_self (fd)
int fd;
{
    return (ether_send_self (fd));
}

int
ether_bcast_self (fd)
int fd;
{
    unsigned char *devname = sad.dli_device.dli_devname;

    if (!strcmp ((char *) devname, "ec"))
	return (0);			/* the ec driver is broken... */

    return (1);				/* default to true */
}
