/* $Id: dlireadv.c,v 2.1 89/10/23 15:42:06 dupuy Exp $ */

#include <sys/param.h>			/* NOFILE */
#include <sys/socket.h>			/* sockaddr_dl (sockaddr) */
#include <sys/uio.h>			/* iovec */

#include <net/if.h>			/* ifdevea */
#include <netinet/in.h>			/* (ether_header) (in_addr) */
#include <netinet/if_ether.h>		/* sockaddr_dl (ether_header) */
#include <netdnet/dli_var.h>		/* sockaddr_dl */

#include <errno.h>			/* EWOULDBLOCK */

#include "libether.h"

extern ether_addr _ether_multi_addrs[NOFILE];


/*
 * Reads and returns a single packet, filling in all fields.  Has to do
 * address checking, since we are operating in DLI_EXCLUSIVE mode.
 */

int
ether_readv (fd, packet)
int fd;
ether_vec *packet;
{
    struct sockaddr_dl from;
    struct msghdr msg;
    int count;
    char *dest;

    from.dli_family = AF_DLI;
    msg.msg_iov = packet->iov;
    msg.msg_iovlen = packet->iovcnt;
    msg.msg_name = (caddr_t) &from;
    msg.msg_namelen = sizeof (from);
    msg.msg_accrights = 0;
    msg.msg_accrightslen = 0;

    do					/* ignore bogus multicast packets */
    {
	if ((count = recvmsg (fd, &msg, 0)) < 0)
	{
	    if (errno == EWOULDBLOCK)
		errno = EAGAIN;
	    return (-1);
	}

	dest = (char *) from.choose_addr.dli_eaddr.dli_dest;
    }
    while (address_check (dest));	/* constant argument to NOT ??? */

    bcopy (dest, (char *) &packet->dest, sizeof (ether_addr));
    bcopy ((char *) from.choose_addr.dli_eaddr.dli_target,
	   (char *) &packet->src, sizeof (ether_addr));
    packet->type[0] = (from.choose_addr.dli_eaddr.dli_protype & 0xff00) >> 8;
    packet->type[1] = from.choose_addr.dli_eaddr.dli_protype & 0xff;

    return (count);
}
