/* generic packet spoofing routines. 
 * Michael R. Widner
 */

/* This should compile under bsd or sysv. */
#ifdef SYSV
#define bcopy(b1,b2,len) memmove(b2, b1, (size_t)(len))
#define bzero(b,len) memset(b, 0, (size_t)(len))
#endif

#ifdef LINUX
/* Linux appears to need me to include endian.h.  */
#include <endian.h>
#endif


/* Pretty generous group of includes.  Someday I'll narrow this list. */
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/signal.h>

#ifdef LINUX
#include <bsd/netinet/in_systm.h>
#include <bsd/netinet/in.h>
#include <bsd/netinet/ip.h>
#include <bsd/netinet/ip_icmp.h>
#include <bsd/netinet/ip_var.h>
#include <bsd/netinet/tcp.h>
#include <bsd/netinet/udp.h>
#include <bsd/netinet/if_ether.h>
#else
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#endif
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>

#include "packet_spoof.h"

#define MAXPACKET       (65536 - 60 - 8) /* max packet size */

/*
 * in_cksum --
 *      Checksum routine for Internet Protocol family headers (C Version)
 */
u_short in_cksum(addr, len)
        u_short *addr;
        int len;
{
        register int nleft = len;
        register u_short *w = addr;
        register int sum = 0;
        u_short answer = 0;

        /*
         * Our algorithm is simple, using a 32 bit accumulator (sum), we add
         * sequential 16 bit words to it, and at the end, fold back all the
         * carry bits from the top 16 bits into the lower 16 bits.
         */
        while (nleft > 1)  {
                sum += *w++;
                nleft -= 2;
        }

        /* mop up an odd byte, if necessary */
        if (nleft == 1) {
                *(u_char *)(&answer) = *(u_char *)w ;
                sum += answer;
        }

        /* add back carry outs from top 16 bits to low 16 bits */
        sum = (sum >> 16) + (sum & 0xffff);     /* add hi 16 to low 16 */
        sum += (sum >> 16);                     /* add carry */
        answer = ~sum;                          /* truncate to 16 bits */
        return(answer);
}


/*
 * build_ip_header --
 *      builds an ip header, given the required information.
 *      as most things in this prog, ip_start must be aligned.
 *      proto is the protocol, generally IPPROTO_ICMP or
 *      IPPROTO_UDP or something like that.  len is the length of
 *      the remainder of the packet you're taking on after this.
 */
int build_ip_header(ip_start,src,dest,len,proto)
u_long src,dest;
unsigned char *ip_start,proto;
int len;
{
        struct ip *iphead;

        /* Create our fake IP header here. */
        iphead=(void *)ip_start;

        /* ip header for icmp. */
        iphead->ip_v=4;         /* version 4 ip */
        iphead->ip_hl=5;        /* header length in 32-bit words */
        iphead->ip_tos=0;       /* type of service is 0 */
        iphead->ip_len=len;     /* length of whole paket. */
        iphead->ip_id=0x3412;   /* identification - do we need it? */
        iphead->ip_off=0;       /* fragment offset */
        iphead->ip_ttl=100;      /* arbitrary ttl remaining */
        iphead->ip_p=proto;
        iphead->ip_sum=0;       /* type short:  checksum */
	/* How's this for ugliness? */
        iphead->ip_src=*(struct in_addr *)&src; /* source address */
        iphead->ip_dst=*(struct in_addr *)&dest;  /* destination address */

        /* set ip packet size and compute checksum */
        iphead->ip_len=htons((sizeof(struct ip)+len));
        iphead->ip_sum=(in_cksum((u_short *)iphead,sizeof(struct ip)));

        /* return the length of only what we just did. */
        return(20);
}

/*
 * build_tcp_packet - puts together a short tcp packet
 *              Puts resulting packet in d_block, taking tcp data from
 *              s_block.
 */
int build_tcp_packet(d_block,s_block,len,src,s_port,dest,d_port,seq,ack,flags)
        u_char *d_block,*s_block,flags;
        unsigned short s_port, d_port;
        u_long seq,ack;
        int len;
        u_long src,dest;
{
        int x,i;
        struct tcphdr *tcp_start;
        struct in_addr *nonsense;

        tcp_start=(void *)d_block;
        tcp_start->th_sport=htons(s_port);
        tcp_start->th_dport=htons(d_port);
        tcp_start->th_seq=htonl(seq);
        tcp_start->th_ack=htonl(ack);
        tcp_start->th_off=5;
        tcp_start->th_flags=flags;
        tcp_start->th_win=htons(4096);
        tcp_start->th_sum=0;
        tcp_start->th_urp=0;

        /* Copy the data into the packet */
        memcpy(d_block+20,s_block,len);

        /* Round it out so that it ends on a 4 byte boundry.
           This is ugliness. */
        i=len+20;
        x=len/4;
        x=x*4;
        if (x<len) {
                x=4-len+x;
                for(;i<(len+20+x);i++)
                        d_block[i]=0;
        }

/* It's really annoying that we have to do this...
 * The TCP checksum has to include data from a psuedo IP header that
 * consists of source addr, dest addr, zero, protocol, tcp length
 * that are       4            4        1       1        2    bytes each.
 * A total of 12 bytes that aren't really sent, but included in checksums */
        nonsense=(struct in_addr *)&d_block[i];
        *nonsense=*(struct in_addr *)&src;
        nonsense=(struct in_addr *)&d_block[i+4];
        *nonsense=*(struct in_addr *)&dest;
        d_block[i+8]=0;
        d_block[i+9]=IPPROTO_TCP;   /* IPPROTO_TCP */
        d_block[i+10]=0;
        d_block[i+11]=len+20;

        tcp_start->th_sum=in_cksum((unsigned short *)d_block,i+12);
        return(len+20);
}


/*
 * build_udp_packet - puts together a short udp packet
 *              Puts resulting packet in d_block, taking udp data from
 *              s_block.
 */
int build_udp_packet(d_block,s_block,len,src,s_port,dest,d_port)
        u_char *d_block,*s_block;
        unsigned short s_port, d_port;
        int len;
        u_long src,dest;
{
        int x,i;
        struct udphdr *udp_start;
        struct in_addr *nonsense;

        udp_start=(void *)d_block;
        udp_start->uh_sport=htons(s_port);
        udp_start->uh_dport=htons(d_port);
        udp_start->uh_ulen=htons(len+8);
        udp_start->uh_sum=0;

        /* Copy the data into the packet */
        memcpy(d_block+8,s_block,len);

        /* Round it out so that it ends on a 4 byte boundry.
           This is ugliness. */
        i=len+8;
        x=len/4;
        x=x*4;
        if (x<len) {
                x=4-len+x;
                printf("len=%i  x=%i  i=%i  ",len,x,i);
                for(;i<(len+8+x);i++)
                        d_block[i]=0;
                printf("final i: %i \n",i);
        }

/* It's really annoying that we have to do this...
 * The UDP checksum has to include data from a psuedo IP header that
 * consists of source addr, dest addr, zero, protocol, udp length
 * that are       4            4        1       1        2    bytes each.
 * A total of 12 bytes that aren't really sent, but included in checksums */
        nonsense=(struct in_addr *)&d_block[i];
        *nonsense=*(struct in_addr *)&src;
        nonsense=(struct in_addr *)&d_block[i+4];
        *nonsense=*(struct in_addr *)&dest;
        d_block[i+8]=0;
        d_block[i+9]=17;   /* IPPROTO_UDP */
        d_block[i+10]=0;
        d_block[i+11]=len+8;

        udp_start->uh_sum=in_cksum((unsigned short *)d_block,i+12);
        return(len+8);
}

/* convert ascii ethernet address to 6 bytes - ripped from etherlib */
struct ether_addr *ether_a2e (estring)
char *estring;
{
    unsigned bytes[6];
    struct ether_addr *addr;
    int i;

    addr = (struct ether_addr *)malloc(sizeof(struct ether_addr));

    if (sscanf (estring, " %2x:%2x:%2x:%2x:%2x:%2x", &bytes[0], &bytes[1],
                &bytes[2], &bytes[3], &bytes[4], &bytes[5]) == 6 ||
        sscanf (estring, " %2x-%2x-%2x-%2x-%2x-%2x", &bytes[0], &bytes[1],
                &bytes[2], &bytes[3], &bytes[4], &bytes[5]) == 6)
    {
        for (i = 0; i < 6; i++)
            addr->ether_addr_octet[i] = bytes[i];
    }
    else
    {
      printf("Fatal error: could not convert %s to ethernet addr.\n",estring);
      exit(255);
    }
    return (addr);
}


/* sendtcppacket_simple(
*     struct ether_addr source_hardware_address,
*     struct ether_addr destination_hardware_address,
*     u_long            source_ip_address,
*     u_long            destination_ip_address,
*     u_short           source_port,
*     u_short           destination_port,
*     u_long            sequence_number,
*     u_long            acknowldegement_number,
*     int               TCP flags (SYN, RST, ACK, PUSH, FIN),
*     char *            data,
*     int               datalen)
*/
int sendtcppacket_simple(esource, edest, source_ip, dest_ip,
			source_port, dest_port, seq_num, ack_num,
			tcp_flags, data, datalen)
	struct ether_addr *esource, *edest;
	u_long source_ip, dest_ip;
	u_short source_port, dest_port;
	u_long seq_num, ack_num;
	int tcp_flags;
	char *data;
	int datalen;
{
	u_char *ip_header, *tcp_packet, *whole_packet, *next_loc;
	int packet_size, tcp_size, ip_size, sentsize;

	whole_packet=(u_char *)malloc(MAXPACKET);
	tcp_packet=(u_char *)malloc(MAXPACKET);
	ip_header=whole_packet;
	next_loc=whole_packet;
	
	/* build the tcp part of the packet.  ip header added on later */
	tcp_size=build_tcp_packet(tcp_packet, data, datalen,
		source_ip, source_port,
		dest_ip, dest_port,
		seq_num, ack_num, tcp_flags);

	/* build the ip header for the tcp packet... */
	ip_size=build_ip_header(ip_header,source_ip,dest_ip,
		tcp_size,IPPROTO_TCP);

	/* adjust pointers after the ip header */
	next_loc=next_loc+ip_size;
	packet_size=ip_size;

	/* append the fake tcp packet. */
	memcpy(next_loc,tcp_packet,tcp_size);
	next_loc=next_loc+tcp_size;
	packet_size=packet_size+tcp_size;

	sentsize=send_raw_packet(edest, whole_packet, packet_size);
	return(sentsize);
}


/* sendudppacket_simple(
*     struct ether_addr source_hardware_address,
*     struct ether_addr destination_hardware_address,
*     u_long            source_ip_address,
*     u_long            destination_ip_address,
*     u_short           source_port,
*     u_short           destination_port,
*     char *            data,
*     int               datalen)
*/
int sendudppacket_simple(esource, edest, source_ip, dest_ip,
			source_port, dest_port, data, datalen)
	struct ether_addr *esource, *edest;
	u_long source_ip, dest_ip;
	u_short source_port, dest_port;
	char *data;
	int datalen;
{
	u_char *ip_header, *udp_packet, *whole_packet, *next_loc;
	int packet_size, udp_size, ip_size, sentsize;

	whole_packet=(u_char *)malloc(MAXPACKET);
	udp_packet=(u_char *)malloc(MAXPACKET);
	ip_header=whole_packet;
	next_loc=whole_packet;
	
	/* build the udp part of the packet.  ip header added on later */
	udp_size=build_udp_packet(udp_packet, data, datalen,
		source_ip, source_port, dest_ip, dest_port);

	/* build the ip header for the tcp packet... */
	ip_size=build_ip_header(ip_header,source_ip,dest_ip,
		udp_size,IPPROTO_UDP);

	/* adjust pointers after the ip header */
	next_loc=next_loc+ip_size;
	packet_size=ip_size;

	/* append the fake udp packet. */
	memcpy(next_loc,udp_packet,udp_size);
	next_loc=next_loc+udp_size;
	packet_size=packet_size+udp_size;

	sentsize=send_raw_packet(edest, whole_packet, packet_size);
	return(sentsize);
}
