/* $Id: nitaddr.c,v 2.1 89/10/23 15:43:02 dupuy Exp $ */

#include <sys/types.h>			/* ifreq (u_short) */
#include <sys/socket.h>			/* ifreq (sockaddr) */
#include <net/if.h>			/* ifreq */
#include <sys/ioctl.h>			/* SIOCGIFADDR */

#include "libether.h"

ether_addr _ether_localaddr;		/* shared with ether_intfaddr() */
int _ether_haveaddress;			/* shared with ether_intfaddr() */

/*
 * Returns the local ethernet address for the ethernet interface on the file
 * descriptor fd.  The result is stored in the structure given by address; if
 * none is given, malloc is used to allocate space.  Sun systems have the
 * "feature" that all ethernet interfaces are set to the same address (taken
 * from the ID PROM).  So we can get the answer once, and use it forever.
 */

ether_addr *
ether_address (fd, address)
int fd;
ether_addr *address;
{
    if (!_ether_haveaddress)
    {
	struct ifreq ifr;

	ifr.ifr_addr.sa_family = AF_NIT;
	if (ioctl (fd, SIOCGIFADDR, (char *) &ifr) < 0)
	{
#ifdef DEBUG
	    perror ("ether_address: ioctl SIOCGIFADDR");
#endif
	    return (0);
	}

	bcopy (ifr.ifr_addr.sa_data, (char *) &_ether_localaddr,
	       sizeof (ether_addr));

	_ether_haveaddress = 1;
    }

    if (address == 0)
	address = (ether_addr *) malloc (sizeof (ether_addr));

    if (address != 0)
	*address = _ether_localaddr;

    return (address);
}
