/* $Id: nit3intaddr.c,v 2.1 89/10/23 15:42:47 dupuy Exp $ */

#include <sys/types.h>			/* AF_NIT (u_short) */
#include <sys/socket.h>			/* AF_NIT */

extern int errno;

#include "libether.h"

ether_addr _ether_localaddr;		/* shared with ether_address() */
int _ether_haveaddress;			/* shared with ether_address() */

/*
 * Returns the local ethernet address for an ethernet interface.  The result
 * is stored in the structure given by address; if none is given, malloc is
 * used to allocate space.  Sun systems have the "feature" that all ethernet
 * interfaces are set to the same address (taken from the ID PROM).  So we can
 * get the answer once, and use it forever.
 */

/* ARGSUSED */

ether_addr *
ether_intfaddr (intf, address)
char *intf;
ether_addr *address;
{
    if (!_ether_haveaddress)
    {
	int fd;
	int saved_errno;

	if ((fd = socket (AF_NIT, SOCK_RAW, 0)) < 0)
	{
#ifdef DEBUG
	    perror ("ether_open: socket");
#endif
	    return (0);
	}

	address = ether_address (fd, address);

	saved_errno = errno;
	(void) close (fd);
	errno = saved_errno;

	return (address);
    }

    if (address == 0)
	address = (ether_addr *) malloc (sizeof (ether_addr));

    if (address != 0)
	*address = _ether_localaddr;

    return (address);
}
