/* $Id: ethere2ip.c,v 2.1 89/10/23 15:42:32 dupuy Exp $ */

#include <sys/param.h>			/* MAXHOSTNAMELEN */
#include <sys/socket.h>			/* AF_INET */
#include <netinet/in.h>			/* in_addr */

#include <netdb.h>			/* hostent */

#include "libether.h"

struct in_addr *
ether_e2ip (addr, ipaddr)
ether_addr *addr;
struct in_addr *ipaddr;
{
#ifdef ETHERDB
    char hname[MAXHOSTNAMELEN];
    struct hostent *host;
#endif
    int allocated = 0;

    if (ipaddr == NULL)
    {
	ipaddr = (struct in_addr *) malloc (sizeof (struct in_addr));
	allocated++;
    }

    if (ipaddr == NULL)
	return (NULL);

#ifdef ETHERDB
    if (ether_ntohost (hname, addr) == 0)
    {

	/*
	 * Unfortunately, gethostbyname is not reentrant.  It should be.
	 */

	if ((host = gethostbyname (hname)) && host->h_addrtype == AF_INET)
	{
	    ether_addr arpaddr;
	    struct in_addr haddr;
	    int arpsucceeded = 0;

	    /*
	     * We have the answer(s), but they may be wrong.  Check with ARP.
	     */

#ifdef h_addr				/* we have a list */
	    char **hlist;

	    for (hlist = host->h_addr_list; *hlist != NULL; hlist++)
	    {
		bcopy (*hlist, (char *) &haddr, sizeof (haddr));
#else
		bcopy (host->h_addr, (char *) &haddr, sizeof (haddr));
#endif
		if (ether_ip2e (&haddr, &arpaddr))
		{
		    if (ether_cmp (&arpaddr, addr) == 0)
		    {
			*ipaddr = haddr;
			return (ipaddr);
		    }
#ifdef DEBUG				/* warn that etherdb is incorrect */
		    else
		    {
			char ethera[ETHERSTRLEN];
			char etherb[ETHERSTRLEN];
			
			(void) printf ("bad ether address for %s: %s/%s\n",
				       host->h_name,
				       ether_e2a (addr, ethera),
				       ether_e2a (&arpaddr, etherb));
		    }
#endif
		    arpsucceeded++;
		}
#ifdef h_addr
	    }
#endif
	    if (!arpsucceeded)
	    {

		/*
		 * We couldn't ARP the address(es).  So we'll use the primary.
		 */
		bcopy (host->h_addr, (char *) ipaddr, sizeof (*ipaddr));
		return (ipaddr);
	    }
	}
    }
#endif

    /*
     * While the ethers db may be wrong, proxy ARP makes using the ARP table
     * even more prone to error.  If RARP were better supported by more
     * machines, we would do well to use it before this.
     */

    /*
     * At this point we would like to ioctl the arp table and see if we
     * already have an entry for this ethernet address.	 But the arp table is
     * hashed by protocol address, not by ethernet address, so we have to
     * grovel though /dev/kmem and look at all the entries.  And after that,
     * we may not find an entry for the ethernet address anyhow.
     */

    if (_ether_arpscan (addr, ipaddr))
	return (ipaddr);

    /*
     * Since the kernel doesn't keep an entry for the local interfaces in the
     * arp table, we also check the ethernet addresses for each of those
     * looking for a match.
     */

    if (_ether_localif (addr, ipaddr))
	return (ipaddr);

#ifdef RARP

    /*
     * Now the only alternative left is to use RARP (via ether_open, etc.) to
     * try to get the IP address.  Unfortunately, most machines won't RARP for
     * themselves, so this isn't terribly useful either.  Especially since we
     * probably need superuser privilege to call ether_open!
     */

    if (_ether_rarpprobe (addr, ipaddr))
	return (ipaddr);
#endif

    if (allocated)			/* sigh, dispose it */
	(void) free ((char *) ipaddr);

    return (NULL);			/* too bad, we failed */
}
