/* $Id: ethera2e.c,v 2.1 89/10/23 15:42:22 dupuy Exp $ */

#include <stdio.h>			/* sscanf */

#include "libether.h"

#define EBYTES 6

ether_addr *
ether_a2e (estring, addr)
char *estring;
ether_addr *addr;
{
    unsigned bytes[EBYTES];
    int allocated = 0;
    int i;

    if (addr == NULL)
    {
	addr = (ether_addr *) malloc (sizeof (ether_addr));
	allocated++;
    }

    if (addr != NULL)
	if (sscanf (estring, " %2x:%2x:%2x:%2x:%2x:%2x", &bytes[0], &bytes[1],
		    &bytes[2], &bytes[3], &bytes[4], &bytes[5])
	    == EBYTES ||
	    sscanf (estring, " %2x-%2x-%2x-%2x-%2x-%2x", &bytes[0], &bytes[1],
		    &bytes[2], &bytes[3], &bytes[4], &bytes[5])
	    == EBYTES)
	{
	    for (i = 0; i < EBYTES; i++)
		addr->bytes[i] = bytes[i];
	}
	else
	{
	    if (allocated)
		(void) free ((char *) addr);
	    addr = NULL;
	}

    return (addr);
}

#ifndef ETHERDB

ether_addr *
ether_aton (estring)
char *estring;
{
    static ether_addr addr;

    return (ether_a2e (estring, &addr));
}

#endif
