/* $Id: enetblock.c,v 2.0 89/10/20 19:02:00 dupuy Exp $ */

#include <sys/types.h>			/* eniocb (u_char) */
#include <net/enet.h>			/* eniocb */

#define ERR (-1)

/*
 * If state is false (0), set ethernet file descriptor fd to be non-blocking,
 * else set fd to be blocking. If there is an error, ether_blocking() returns
 * (-1) and the appropriate value is left in errno.  Normal return status
 * zero.
 *
 * We _ought_ to be able to use fcntl like SunOS and Ultrix, but since the enet
 * special device doesn't support the FIONBIO ioctl, we can't.	This is a bug
 * in the enet device driver which should be fixed.  Furthermore, this only
 * prevents blocking on reads (the most common case, admittedly).  Writes to
 * ethernet devices can still block waiting for queue resources.
 */

int
ether_blocking (fd, state)
int fd;
int state;
{
    struct eniocb eni;

    if (state)
	eni.en_rtout = 0;
    else
	eni.en_rtout = -1;

    return (ioctl (fd, EIOCSETP, (char *) &eni));
}
