/* $Id: enetaddr.c,v 2.0 89/10/20 19:01:58 dupuy Exp $ */

#include <sys/types.h>			/* FD_ISSET */
#include <sys/ioctl.h>			/* ioctl */

#include <net/enet.h>			/* endevp */

#include "libether.h"

static fd_set addrcachevalid;

static ether_addr ifaddrs[FD_SETSIZE];

#define ifaddr (ifaddrs[fd])

/*
 * Returns the local ethernet address for the ethernet interface on the file
 * descriptor fd.  The result is stored in the structure given by address; if
 * none is given, malloc is used to allocate space.  We cache results here
 * because this function is called every time we send a packet.
 */

ether_addr *
ether_address (fd, address)
int fd;
ether_addr *address;
{
    if (!FD_ISSET (fd, &addrcachevalid))
    {
	struct endevp edev;

	if (ioctl (fd, EIOCDEVP, (char *) &edev) < 0)
	{
#ifdef DEBUG
	    perror ("ether_address: ioctl EIOCDEVP");
#endif
	    return (0);
	}

	bcopy ((char *) edev.end_addr, (char *) &ifaddr, sizeof (ether_addr));

	FD_SET (fd, &addrcachevalid);
    }


    if (address == 0)
	address = (ether_addr *) malloc (sizeof (ether_addr));

    if (address != 0)
	bcopy ((char *) &ifaddr, (char *) address, sizeof (ether_addr));

    return (address);
}

/*
 * This function is called by ether_open to invalidate the local address
 * cache, since the file descriptor may be attached to a different interface.
 */

void
_ether_newaddr (fd)
int fd;
{
    FD_CLR (fd, &addrcachevalid);
}
