/* $Id: etherarp.c,v 2.1 89/10/23 15:42:24 dupuy Exp $ */

#include <sys/types.h>			/* arptab (u_short) */
#include <sys/socket.h>			/* arptab (sockaddr) */
#include <net/if.h>			/* arptab (ifnet) */
#ifdef _SOCKET_				/* 4.0 system? */
#include <net/if_arp.h>			/* arptab (arphdr) */
#endif
#include <netinet/in.h>			/* in_addr */
#include <netinet/if_ether.h>		/* arptab */

#include <sys/file.h>			/* O_RDONLY */
#include <nlist.h>			/* nlist */

#include "libether.h"

/*
 * This only understands IP ARP entries.  Chaos, Appletalk, etc. are unknown.
 * Standard kernels don't keep arp tables for those protocols anyhow.
 */

struct nlist nl[] = {
#define	X_ARPTAB	0
    {"_arptab"},
#define	X_ARPTAB_SIZE	1
    {"_arptab_size"},
    {""},
};

#ifndef KERNEL_FILENAME
#define KERNEL_FILENAME "/vmunix"
#endif

#ifndef KMEM_FILENAME
#define KMEM_FILENAME "/dev/kmem"
#endif

static int
kmem_read (fd, addr, buf, nbytes)
int fd;
unsigned long addr;
char *buf;
unsigned nbytes;
{
    extern long lseek ();

    return (lseek (fd, (long) addr, L_SET) == -1L
	    || read (fd, buf, (int) nbytes) < nbytes);
}

static int
readarptable (atp)
struct arptab **atp;
{
    int kmem;
    int arptab_size;
    int bytes;
    struct arptab *at;

    if (atp == 0)
	return (-1);

    if ((kmem = open (KMEM_FILENAME, O_RDONLY)) < 0)
	return (-1);

    /*
     * Despite what Ultrix lint says, nlist _does_ return a value
     */

    if (nlist (KERNEL_FILENAME, nl) != 0)
	return (-1);

#if defined (sun386) || defined (COFF)
    if (nl[X_ARPTAB_SIZE].n_value == 0)
#else
    if (nl[X_ARPTAB_SIZE].n_type == 0)
#endif
	return (-1);

    if (kmem_read (kmem, nl[X_ARPTAB_SIZE].n_value,
		   (char *) &arptab_size, (unsigned) sizeof (arptab_size)))
	return (-1);

    if (arptab_size <= 0 || arptab_size > 10000)
	return (-1);

    bytes = arptab_size * sizeof (struct arptab);

    if (*atp == 0)
	*atp = at = (struct arptab *) malloc ((unsigned) bytes);
    else
	at = *atp;

    if (at == 0)
	return (0);			/* may be able to get memory later */

    if (kmem_read (kmem, nl[X_ARPTAB].n_value, (char *) at, (unsigned) bytes))
	return (-1);

    (void) close (kmem);

    return (arptab_size);
}

/*
 * This code is derived from "src/etc/arp.c"
 *
 * Copyright (c) 1984 Regents of the University of California. All rights
 * reserved.
 *
 * This code is derived from software contributed to Berkeley by Sun
 * Microsystems, Inc.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that the above copyright notice and this paragraph are duplicated in all
 * such forms and that any documentation, advertising materials, and other
 * materials related to such distribution and use acknowledge that the software
 * was developed by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived from this
 * software without specific prior written permission. THIS SOFTWARE IS
 * PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

int
_ether_arpscan (addr, ipaddr)
ether_addr *addr;
struct in_addr *ipaddr;
{
    static int arptab_size = 0;		/* kernel arptab is fixed size */
    static struct arptab *arptab;
    struct arptab *at;
    int i;
    int again = 0;

    if (arptab_size == 0)
	arptab_size = again = readarptable (&arptab);

    if (arptab_size <= 0)
	return (0);			/* no luck reading arptab */

    while (1)
    {
	for (i = arptab_size, at = arptab; i-- > 0; at++)
	{
	    if (at->at_iaddr.s_addr == 0 || at->at_flags == 0)
		continue;

	    if ((at->at_flags & ATF_COM) == 0)
		continue;

#ifdef sun				/* sun defines at_enaddr as struct */
	    if (!bcmp ((char *) &at->at_enaddr, (char *) addr, sizeof (*addr)))
#else
	    if (bcmp ((char *) at->at_enaddr, (char *) addr, sizeof (*addr))
		== 0)
#endif
	    {
		*ipaddr = at->at_iaddr;
		return (1);
	    }
	}

	if (again)
	    return (0);
	else				/* try again with current table */
	    again = readarptable (&arptab);
    }

    /* NOTREACHED */
}

#ifdef RARP

int
_ether_rarpprobe (addr, ipaddr)
ether_addr *addr;
struct in_addr *ipaddr;
{
    return (0);
}

#endif
