/* $Id: enetintaddr.c,v 2.0 89/10/20 19:02:02 dupuy Exp $ */

#include <strings.h>			/* strcpy */
#include <sys/types.h>			/* (sockaddr) (u_short) */
#include <sys/socket.h>			/* IFNAMSIZ (sockaddr) */
#include <sys/file.h>			/* O_RDWR */
#include <net/if.h>			/* IFNAMSIZ */

extern int errno;

#include "libether.h"

#ifndef ENET_DEVDIR
#define ENET_DEVDIR "/dev/enet/"
#endif

/*
 * Returns the local ethernet address for an ethernet interface.  The result
 * is stored in the structure given by address; if none is given, malloc is
 * used to allocate space.
 */

ether_addr *
ether_intfaddr (intf, address)
char *intf;
ether_addr *address;
{
    char pathname[sizeof (ENET_DEVDIR) + IFNAMSIZ];
    int fd;
    int saved_errno;

    (void) strcpy (pathname, ENET_DEVDIR);
    (void) strncat (pathname, intf, IFNAMSIZ);

    if ((fd = open (pathname, O_RDWR)) < 0)
    {
#ifdef DEBUG
	perror (pathname);
#endif
	return (0);
    }

    address = ether_address (fd, address);

    saved_errno = errno;
    (void) close (fd);
    errno = saved_errno;

    return (address);
}
