/* $Id: dliopen.c,v 2.1 89/10/23 15:42:00 dupuy Exp $ */

#include <sys/param.h>			/* NOFILE */
#include <sys/socket.h>			/* sockaddr_dl (sockaddr) */

#include <net/if.h>			/* ifdevea */
#include <netinet/in.h>			/* (ether_header) (in_addr) */
#include <netinet/if_ether.h>		/* sockaddr_dl (ether_header) */
#include <netdnet/dli_var.h>		/* sockaddr_dl */

#include <ctype.h>			/* isdigit */
#include <errno.h>			/* EMFILE */

#include "libether.h"

ether_addr _ether_multi_addrs[NOFILE];
struct sockaddr_dl _ether_sockaddrs[NOFILE];

#define multi_addr (_ether_multi_addrs[fd])
#define sad (_ether_sockaddrs[fd])


static void
name_to_devid (devid, name)
struct dli_devid *devid;
char *name;
{
    register int i = 0;

    while ((*name != '\0') && (isalpha (name[i]) != 0) && (i < DLI_DEVSIZE))
    {
	devid->dli_devname[i] = name[i];
	i++;
    }

    devid->dli_devname[i] = '\0';

    devid->dli_devnumber = atoi (&name[i]);
}


/*
 * Returns file descriptor for ethernet device by name ("de0", "qe0", etc.).
 * If name is NULL, uses primary ethernet interface.  Will only receive
 * packets of type specified.  Will receive packets for the ethernet address
 * specified, or local ethernet address if NULL.  If there is an error,
 * returns (-1) and the appropriate value is left in errno.  Normal return
 * status zero. Requires superuser privilege.
 */

int
ether_open (name, type, address)
char *name;
unsigned type;
ether_addr *address;
{
    int fd;
    char **interfaces;
    int saved_errno;			/* close seems to blow errno away */

    if (name == 0)
    {					/* get default ethernet interface */
	interfaces = ether_interfaces ();
	if (interfaces == 0 || *interfaces == 0)
	    return (-1);

	name = *interfaces;		/* just use the first name in list */
    }

    if ((fd = socket (AF_DLI, SOCK_DGRAM, DLPROTO_DLI)) < 0)
    {
#ifdef DEBUG
	perror ("ether_open: socket");
#endif
	return (-1);
    }

    if (fd >= NOFILE)			/* not worth making it work here */
    {
	(void) close (fd);
	errno = EMFILE;
	return (-1);
    }

    if (type > ETHER_MAXTYPE)
    {
	(void) close (fd);
	errno = EINVAL;
	return (-1);
    }

    bzero (&sad, sizeof (sad));
    sad.dli_family = AF_DLI;
    sad.dli_substructype = DLI_ETHERNET;
    name_to_devid (&sad.dli_device, name);
    sad.choose_addr.dli_eaddr.dli_ioctlflg = DLI_EXCLUSIVE;
    sad.choose_addr.dli_eaddr.dli_protype = type;

    if (bind (fd, (struct sockaddr *) &sad, sizeof (sad)) != 0)
    {
	saved_errno = errno;
#ifdef DEBUG
	perror ("ether_open: bind");
#endif
	(void) close (fd);
	errno = saved_errno;
	return (-1);
    }

    if (address != 0)			/* a multicast address */
    {
	if (setsockopt (fd, DLPROTO_DLI, DLI_MULTICAST, (char *) address,
			sizeof (ether_addr)) != 0)
	{
	    saved_errno = errno;
#ifdef DEBUG
	    perror ("ether_open: setsockopt");
#endif
	    (void) close (fd);
	    errno = saved_errno;
	    return (-1);
	}
	multi_addr = *address;
    }
    else
	multi_addr = ether_bcast_addr;

    sad.choose_addr.dli_eaddr.dli_ioctlflg = 0;

    return (fd);
}
