/* System specific routines for packet spoofing.
 * I like DLPI, but I put this together in an ugly manner.
 * Michael R. Widner
 */

/* This should compile under bsd or sysv. */
#ifdef SYSV
#define bcopy(b1,b2,len) memmove(b2, b1, (size_t)(len))
#define bzero(b,len) memset(b, 0, (size_t)(len))
#endif

#define MAXPACKET       (65536 - 60 - 8)

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/signal.h>

#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* DLPI specific stuff.  Better be there. */
#include <sys/ethernet.h>
#include <sys/dlpi.h>
#include <dlcommon.h>
#include <dltest.h>

/* a global file descriptor */
int ether_fd=-1;
struct ether_header *mrw_ehp; /* I hate globals, but this is easier */

/* I don't use this routine, but I like it so much I left it in.  */
/*
 * Convert x:x:x etc to ethernet address string.
 */
stringtoaddr(sp, addr)
char    *sp;
char    *addr;
{
        int     n = 0;
        char    *p,*new_sp;
        int     val;

        new_sp=strdup(sp);
        p = new_sp;
        while (p = strtok(p, ":")) {
                if (sscanf(p, "%x", &val) != 1)
                        err("stringtoaddr:  invalid input string:  %s", sp);
                if (val > 0xff)
                        err("stringtoaddr:  invalid input string:  %s", sp);
                *addr++ = val;
                n++;
                p = NULL;
        }

        return (n);
}


/* Initialize DLPI interface routine. */
int initialize_dlpi(u_char *edest);
{
	u_char phys[10];
	union DL_primitives *dlp;

	if ((ether_fd=open("/dev/le",2))<0) {
		printf("ERROR: ether open\n");
		exit(255);
		}
	for (i=0;i<MAXDLBUF;i++)
		buf[i]=(unsigned char) i & 0xff;
	dlattachreq(ether_fd,0);
	dlokack(ether_fd,buf);
	dlbindreq(ether_fd,0x800,0,DL_CLDLS,0,0);
	dlbindack(ether_fd,buf);
	dlphysaddrreq(ether_fd, DL_CURR_PHYS_ADDR);
	dlphysaddrack(ether_fd, buf);
	dlp=(union DL_primitives *)buf;
	/* edest is already in the correct form, otherwise I'd use this */
	/* stringtoaddr((edest ? edest : ROUTER_ETHER),phys); */
	memcpy(&mrw_ehp->ether_dhost, edest, ETHERADDRL);
	memcpy(&mrw_ehp->ether_shost,
		OFFADDR(dlp, dlp->physaddr_ack.dl_addr_offset),
		ETHERADDRL);
	mrw_ehp->ether_type=(u_short)0x800;
	if (strioctl(ether_fd, DLIOCRAW, -1, 0, 0) < 0) {
		printf("ERROR: DLIOCRAW\n");
		exit(255);
		}
}


/* send_raw_packet(char *packet, int packet_size)
 * Send out the packet on whatever interface we're using. */
int send_raw_packet(edest, packet, packet_size)
	u_char *edest;
	u_char *packet;
	int packet_size;
{
	u_char *whole_packet;
	int bytes_written;

	whole_packet=(u_char *)malloc(MAXPACKET);

	/* Only open the ethernet descriptor once. */
	if (ether_fd==-1)
		initialize_dlpi(edest);

	/* Copy the ethernet header part into the whole_packet */
	memcpy (whole_packet,mrw_ehp,sizeof(struct ether_header));

	/* Now tack on the packet */
	memcpy (whole_packet+sizeof(struct ether_header),packet,packet_size);
	bytes_written=write(ether_fd,whole_packet,
			packet_size+sizeof(struct ether_header));

	if (bytes_written<0)
			printf("ERROR:  failed ether write\n");
	return(bytes_written-sizeof(struct ether_header));
}
