/* $Id: nit3writev.c,v 2.0 89/10/20 19:02:42 dupuy Exp $ */

#include <sys/param.h>
#include <sys/socket.h>

#include "libether.h"

extern unsigned _ether_types[NOFILE];

#define ether_type (_ether_types[fd])

/*
 * Writes a single packet, filling src and type fields.
 */

int
ether_writev (fd, packet)
int fd;
ether_vec *packet;
{
    struct sockaddr sa;
    struct msghdr msg;

    sa.sa_family = AF_UNSPEC;
    bcopy ((char *) packet, sa.sa_data, ETHER_TYPE);

    if (ether_type != ETHER_ALLTYPES)
    {
	sa.sa_data[12] = (ether_type >> 8) & 0xff;
	sa.sa_data[13] = ether_type & 0xff;
    }

    msg.msg_iov = packet->iov;
    msg.msg_iovlen = packet->iovcnt;
    msg.msg_name = (caddr_t) & sa;
    msg.msg_namelen = sizeof (sa);
    msg.msg_accrights = 0;
    msg.msg_accrightslen = 0;

    return (sendmsg (fd, &msg, 0) < 0 ? -1 : 0);
}
