/* $Id: nit3write.c,v 2.0 89/10/20 19:02:41 dupuy Exp $ */

#include <sys/param.h>
#include <sys/socket.h>

#include "libether.h"

extern unsigned _ether_types[NOFILE];

#define ether_type (_ether_types[fd])

/*
 * Writes a single packet, filling src and type fields.
 */

int
ether_write (fd, packet)
int fd;
ether_packet *packet;
{
    struct sockaddr sa;

    sa.sa_family = AF_UNSPEC;
    bcopy ((char *) packet, sa.sa_data, ETHER_TYPE);

    if (ether_type != ETHER_ALLTYPES)
    {
	sa.sa_data[12] = (ether_type >> 8) & 0xff;
	sa.sa_data[13] = ether_type & 0xff;
    }

    return (sendto (fd, packet->pktbuf, (int) packet->pktlen, 0, &sa,
		    sizeof (sa)) < 0 ? -1 : 0);
}
