/* $Id: nit3readv.c,v 2.0 89/10/20 19:02:38 dupuy Exp $ */

#include <sys/types.h>			/* iovec (caddr_t) */
#include <sys/uio.h>			/* iovec */

#include "libether.h"

/*
 * Reads and returns a single packet, filling in all fields.  Since read() may
 * return several packets at a time, we have to buffer them as well.  Since
 * socket based nit doesn't handle multicast addresses, we have to check them
 * at the user level.
 *
 * NOTE - the buffering code is not re-entrant, although different fd's will
 * not conflict.
 */

int
ether_readv (fd, packet)
int fd;
ether_vec *packet;
{
    char *pbuf;
    int index = 0;
    int count;
    int bytes;

    if ((bytes = _ether_next_packet (fd, &pbuf)) < 0)
	return (-1);

    bcopy (pbuf, (char *) packet, ETHER_PKT);
    pbuf += ETHER_PKT;

    for (count = 0; count < packet->iovcnt && index < bytes; count++)
	if (packet->iov[count].iov_len)
	{
	    if (bytes - index < packet->iov[count].iov_len)
	    {
		bcopy (&pbuf[index], (char *) packet->iov[count].iov_base,
		       bytes - index);
		break;
	    }
	    else
	    {
		bcopy (&pbuf[index], (char *) packet->iov[count].iov_base,
		       (int) packet->iov[count].iov_len);
		index += packet->iov[count].iov_len;
	    }
	}

    return (bytes);
}
