/* $Id: etherints.c,v 2.0 89/10/20 19:02:24 dupuy Exp $ */

#include <strings.h>			/* strcmp */

#include <sys/types.h>			/* AF_INET (u_char) */
#include <sys/socket.h>			/* AF_INET */
#include <net/if.h>			/* IFNAMSIZ */
#ifdef _SOCKET_				/* 4.0 system? */
#include <sys/sockio.h>			/* SIOCGIFCONF */
#else
#endif
#include <sys/ioctl.h>			/* ioctl */

#include "libether.h"

static char checked;			/* boolean flag */

static char *result[MAXNUMIF];
static char names[MAXNUMIF * IFNAMSIZ];
#ifdef sun
static char *validname[] = {"le", "ie", "ec", 0};

#endif
#ifdef vax
static char *validname[] = {"de", "ec", "ex", "il", "ni", "qe", "se", 0};

#endif
#ifdef mips
static char *validname[] = {"lo", "ni", "qe", "se", 0};

#endif


short _ether_ifindex[MAXNUMIF];		/* used by _ether_localif() */
struct ifconf _ether_ifconf;		/* used by _ether_localif() */
static char cbuf[MAXNUMIF * sizeof (struct ifreq)];

/*
 * Returns an array of strings (with last element 0) each entry of which is an
 * ethernet interface name valid for use in ether_open().  Valid prefixes for
 * ethernet interface names are in validname.  Assumes that the device
 * prefixes are unique (i.e. no eckankar0 device exists).
 */

char **
ether_interfaces ()
{
    int sfd;

    register int i;
    register int j;
    register int k;
    register int l;
    int numinter;

    if (checked)
	return (result);		/* we have alread done this */

    /* we have not yet checked the interfaces */

    if ((sfd = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
#ifdef DEBUG
	perror ("libether socket:");
#endif
	return (0);
    }

    _ether_ifconf.ifc_len = sizeof (cbuf);
    _ether_ifconf.ifc_buf = cbuf;
    if (ioctl (sfd, SIOCGIFCONF, (char *) &_ether_ifconf) < 0)
    {
#ifdef DEBUG
	perror ("libether SIOCGIFCONF:");
#endif
	(void) close (sfd);
	return (0);
    }

    k = 0;
    numinter = _ether_ifconf.ifc_len / sizeof (struct ifreq);
    for (i = 0; i < numinter; i++)
    {
	for (j = 0; validname[j] != 0; j++)
	    if (strncmp (_ether_ifconf.ifc_req[i].ifr_name,
			 validname[j], 2) == 0)
	    {
		for (l = 0; l < k; l++)
		    if (!strcmp (result[l], _ether_ifconf.ifc_req[i].ifr_name))
		    {
			if (_ether_ifconf.ifc_req[i].ifr_addr.sa_family
			    == AF_INET)
			    _ether_ifindex[l] = i;

			goto duplicate;
		    }

		(void) strncpy (names + IFNAMSIZ * k,
				_ether_ifconf.ifc_req[i].ifr_name, IFNAMSIZ);
		result[k] = names + IFNAMSIZ * k;
		if (_ether_ifconf.ifc_req[i].ifr_addr.sa_family == AF_INET)
		    _ether_ifindex[k] = i;
		else
		    _ether_ifindex[k] = -1;
		++k;
	    }
      duplicate:
	;
    }
    result[k] = 0;


    (void) close (sfd);
    checked = 1;
    return (result);
}
