/* $Id: enetwrite.c,v 2.1 89/10/24 17:53:05 dupuy Exp $ */

#include <sys/types.h>			/* iovec (caddr_t) */
#include <sys/uio.h>			/* iovec */

#include "libether.h"

extern unsigned _ether_types[FD_SETSIZE];

#define ether_type (_ether_types[fd])

#define HEADER	0
#define DATA	1
#define MAXIOV	2

/*
 * Writes a single packet, filling src and type fields.	 We have to fill in
 * the src field in user space, since the enetfilter doesn't do it for us, and
 * at least some VAX interface devices don't do it either.
 */

int
ether_write (fd, packet)
int fd;
ether_packet *packet;
{
    struct iovec iov[MAXIOV];

    iov[HEADER].iov_len = ETHER_PKT;
    iov[HEADER].iov_base = (char *) packet;

    iov[DATA].iov_len = packet->pktlen;
    iov[DATA].iov_base = packet->pktbuf;

    if (ether_type != ETHER_ALLTYPES)
    {
	packet->type[0] = (ether_type >> 8) & 0xff;
	packet->type[1] = ether_type & 0xff;
    }

    (void) ether_address (fd, (ether_addr *) &packet->src);

    return (writev (fd, iov, MAXIOV));
}
