/* $Id: etherblock.c,v 2.1 89/10/23 15:42:26 dupuy Exp $ */

#include <sys/file.h>			/* FNBIO/FNDELAY */

#ifdef __STDC__
extern int fcntl (int f, int c, int a);
#else
extern int fcntl ();
#endif

#ifdef FNBIO
#define FNOBLOCK FNBIO
#else
#define FNOBLOCK FNDELAY
#endif

#define ERR (-1)

/*
 * If state is false (0), set ethernet file descriptor fd to be non-blocking,
 * else set fd to be blocking. If there is an error, ether_blocking() returns
 * (-1) and the appropriate value is left in errno.  Normal return status
 * zero.
 */

int
ether_blocking (fd, state)
int fd;
int state;
{
    int flags;

    if ((flags = fcntl (fd, F_GETFL, -1)) < 0)
	return (ERR);

    if (state)
	if (flags & FNOBLOCK)
	    state = fcntl (fd, F_SETFL, flags & ~FNOBLOCK);
	else
	    state = 0;
    else if ((flags & FNOBLOCK) == 0)
	state = fcntl (fd, F_SETFL, flags | FNOBLOCK);

    return (state);
}
