

#define TEST
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>

#define MAXIP    4096    /* most data we'll put in an IP packet */
#define MAXETHER MAXIP+14

int if_fd;
char *interface=0;

int raw_socket()
{
  if_fd=socket(AF_INET,SOCK_PACKET,htons(0x0800));  
  if(if_fd <0) {
    perror("socket");
    return(if_fd);
  }
  return(if_fd);
}

send_packet(p,len)
char *p;
int len;
{
  struct sockaddr add;
  int dlen,x;

  /* address shouldnt matter */ 
  strcpy(add.sa_data,interface);
  dlen = sizeof(add);

#ifdef TEST
  for(x=0;x<len;x++)
    printf("%02x%c",(unsigned char)p[x],((x+1)%8)?' ':'\n');
  printf("\n");
#endif /*TEST*/

  x=sendto(if_fd,p,len,0,(struct sockaddr *)&add,dlen);
  if(x<0) {
    perror("sendto");
    return(-1);
  }
  return(x);
}

unsigned short checksum(data,len)
unsigned short *data;
int len;
{
  unsigned long sum;

  for(sum=0;len;len--) 
    sum += *data++;
  sum = (sum>>16) + (sum & 0xffff);
  sum += (sum>>16); 
  return(~sum);
}

send_ether(data,len)
char *data;
int len;
{
  /* unsigned char ether[14+MAXETHER];
   */
  int i;

  unsigned char ether[14+ MAXETHER] =  {
            0xaa, 0x00, 0x04, 0x00, 0xab, 0x60,
            0xaa, 0x00, 0x04, 0x00, 0xab, 0x60,
            /* 0x00, 0x00, 0x01, 0x02, 0x66, 0x05, */
            0x08, 0x00, };
/*  for(i=0;i<6;i++) {
    ether[i] = 0xff;
  }
*/
  ether[12] = 0x08;      /* 0x0800 = IP */
  ether[13] = 0x00;
  bcopy(data,(char *)ether + 14,14+len);
  send_packet((char *)ether,14+len); 
}

send_ip(data,len,src,dest,proto)
char *src,*dest;  /* src: a.b.c.d, dest: a.b.c.d */
char *data,proto;
int len;
{
  unsigned char ip[20+MAXIP];  /* ip header here */
  unsigned char *c; 
  unsigned short ck;
  int i;

  if(len>=MAXIP) {
    fprintf(stderr,"IP Packet too big.\n");
    return(-1);
  }
  len += 20;    /* compensate for header length */

  ip[0] = 0x45; /* version 4, length 20 (4*5) */
  ip[1] = 0;    /* tos = 0 */
  ip[2] = (len>>8)&0xff;  /* length */
  ip[3] = (len)&0xff;
  ip[4] = 0x12;           /* id */
  ip[5] = 0x34;
  ip[6] = 0;              /* fragment */
  ip[7] = 0;
  ip[8] = 100;            /* ttl */
  ip[9] = proto;          /* proto */
  ip[10] = 0;             /* checksum */
  ip[11] = 0; 
  for(i=0;i<4;i++) {      /* source and destination */
    ip[12+i] = src[i];
    ip[16+i] = dest[i];
  }
  ck = checksum((unsigned short *)ip,20/2);   /* set checksum appropriately */
  c = (char *) &ck;
  ip[10] = c[0];
  ip[11] = c[1];

  bcopy(data,&ip[20],len-20);  /* copy data into packet */
  send_ether((char *)ip,len);
  return(0);
}

/* send udp echo */
send_udp(data,dlen,sport,dport,src,dest)
char *src,*dest,*data;
int dlen,sport,dport;
{
  unsigned char udp[12 + 8+ 1024],*c;
  unsigned short x;
  int len;

  len = dlen + 8;
  /* pseudo header for checksum */
  bcopy(src,(char *)&udp[0],4);
  bcopy(dest,(char *)&udp[4],4);
  udp[8] = 0;
  udp[9] = 0x11;            /* protocol 17 = udp */
  udp[10] = (len>>8)&0xff;  /* udp length */
  udp[11] = (len)&0xff;

  /* actual packet */
  udp[12] = (sport>>8)&0xff;   /* src port */
  udp[13] = (sport)&0xff;  
  udp[14] = (dport>>8)&0xff;   /* dest port */
  udp[15] = (dport)&0xff;
  udp[16] = (len>>8)&0xff;  /* length */
  udp[17] = (len) &0xff; 
  udp[18] = 0;      /* checksum */
  udp[19] = 0;

  bcopy(data,(char *)udp+20,dlen);
  x = checksum((unsigned short *)udp,(len+12)/2);
  c = (char *) &x;
  udp[18] = c[0];
  udp[19] = c[1];

  send_ip(udp+12,len,src,dest,17);     /* 17 = udp packet */
}

main()
{
  char from[4] = { 128,171,8,9 };
  char to[4]   = { 128,171,7,6 };

  interface = "eth0";   
  if(raw_socket()<0) 
    return(1);
  send_udp("Test 1 2 3\n",8,0x4321,0x1234,from,to);  
  return(0);
}

