/* $Id: nit4writev.c,v 2.0 89/10/20 19:02:48 dupuy Exp $ */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stropts.h>
#include <sys/uio.h>

#include "libether.h"

extern unsigned _ether_types[FD_SETSIZE];

#define ether_type (_ether_types[fd])

/*
 * Writes a single packet, filling src and type fields.
 */

int
ether_writev (fd, packet)
int fd;
ether_vec *packet;
{
    struct sockaddr sa;
    struct strbuf cbuf;
    struct strbuf dbuf;
    char buffer[ETHER_MAX];
    char *bufp = buffer;
    int count;

    sa.sa_family = AF_UNSPEC;
    bcopy ((char *) packet, sa.sa_data, ETHER_TYPE);

    if (ether_type != ETHER_ALLTYPES)
    {
	sa.sa_data[12] = (ether_type >> 8) & 0xff;
	sa.sa_data[13] = ether_type & 0xff;
    }

    cbuf.maxlen = cbuf.len = sizeof (sa);
    cbuf.buf = (char *) &sa;

    dbuf.len = 0;
    dbuf.buf = bufp;

    for (count = 0; count < packet->iovcnt; count++)
	if (packet->iov[count].iov_len)
	{
	    bcopy ((char *) packet->iov[count].iov_base, bufp,
		   (int) packet->iov[count].iov_len);
	    bufp += packet->iov[count].iov_len;
	    dbuf.len += packet->iov[count].iov_len;
	}

    return (putmsg (fd, &cbuf, &dbuf, 0));
}
