/* $Id: etherh2e.c,v 2.1 89/10/24 17:53:15 dupuy Exp $ */

#include <sys/types.h>			/* in_addr (u_short) */
#include <netinet/in.h>			/* in_addr */

#include <netdb.h>			/* hostent */
#include <errno.h>			/* ENOENT */

extern int errno;

#include "libether.h"

/*
 * derived from ethertools/htoea.c
 *
 * Copyright (c) 1988 Philip L. Budne and The Trustees of Boston University
 * All Rights Reserved
 *
 * Permission is granted to any individual or institution to use, copy, or
 * redistribute this software so long as it is not sold for profit, provided
 * that this notice and the original copyright notices are retained.  Boston
 * University makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

ether_addr *
ether_host2e (hname, addr)
char *hname;
ether_addr *addr;
{
    int allocated = 0;
    struct in_addr ipaddr;
    struct hostent *host;
    unsigned long inet_addr ();

    if (addr == 0)
    {
	addr = (ether_addr *) malloc (sizeof (ether_addr));
	allocated++;
    }

    if (addr == 0)
	return (0);

    if (ether_a2e (hname, addr))	/* try ascii ethernet address first */
	return (addr);

    if ((ipaddr.s_addr = inet_addr (hname)) != (unsigned) -1)
    {
	if (ether_ip2e (&ipaddr, addr))
	    return (addr);		/* dotted quad notation ok too */
    }

#ifdef ETHERDB

    /*
     * This answer may be wrong, but since the ethers DB may contain non-IP or
     * MAC-level devices, it's hard to really check.
     */
    if (ether_hostton (hname, addr) == 0)
	return (addr);
#endif ETHERDB

    /*
     * Unfortunately, gethostbyname is not reentrant.  It should be.
     */

    if ((host = gethostbyname (hname)) != 0)
    {
	if (ether_hostent2e (host, addr))
	    return (addr);
    }
    else
	errno = ENOENT;			/* not quite the right error message */

    if (allocated)
	(void) free ((char *) addr);
    return (0);
}
