/* $Id: enetopen.c,v 2.1 89/10/23 15:42:14 dupuy Exp $ */

#include <strings.h>			/* strncpy */

#include <sys/file.h>			/* O_RDWR */
#include <sys/types.h>			/* enfilter (u_char) */
#include <sys/socket.h>			/* IFNAMSIZ (sockaddr) */
#include <sys/ioctl.h>			/* ioctl */

#include <net/if.h>			/* IFNAMSIZ */
#include <net/enet.h>			/* enfilter */

#include <netinet/in.h>			/* htons */

#include <errno.h>			/* EMFILE/EINVAL */

extern int errno;

#include "libether.h"

#ifndef ENET_DEVDIR
#define ENET_DEVDIR "/dev/enet/"
#endif

#define packetfilt	enfilter
#define Pf_Priority	enf_Priority
#define Pf_FilterLen	enf_FilterLen
#define Pf_Filter	enf_Filter


static ether_addr promiscuous;

unsigned _ether_types[FD_SETSIZE];

#define ether_type (_ether_types[fd])

#ifdef __STDC__
void _ether_newaddr (int fd);
#else
void _ether_newaddr ();
#endif


static int
eiocsetf (fd, filter)
int fd;
struct packetfilt *filter;
{
    int saved_errno;
    filter->Pf_Priority = 1;		/* should be < 2 */

    if (ioctl (fd, EIOCSETF, (char *) filter) < 0)
    {
	saved_errno = errno;
	(void) close (fd);
	errno = saved_errno;
	return (-1);
    }

    return (0);
}

/*
 * Returns file descriptor for ethernet device by name ("ie0", "le0", etc.).
 * If name is NULL, uses primary ethernet interface.  Will only receive
 * packets of type specified.  Will receive packets for the ethernet address
 * specified, or local ethernet address if NULL.  If there is an error,
 * returns (-1) and the appropriate value is left in errno.  Normal return
 * status zero. Requires superuser privilege.
 */

int
ether_open (name, type, address)
char *name;
unsigned type;
ether_addr *address;
{
    int fd;
    struct packetfilt filter;
    unsigned short *fptr = 0;
    char **interfaces;
    char pathname[sizeof (ENET_DEVDIR) + IFNAMSIZ];
#if !defined(MULTICAST) && defined(PROMISCUOUS)
    register int i;
#endif

    if (name == 0)			/* get default ethernet interface */
    {
	interfaces = ether_interfaces ();
	if (interfaces == 0 || *interfaces == 0)
	    return (-1);

	name = *interfaces;		/* just use the first name in list */
    }

    (void) strcpy (pathname, ENET_DEVDIR);
    (void) strncat (pathname, name, IFNAMSIZ);

    if ((fd = open (pathname, O_RDWR)) < 0)
    {
#ifdef DEBUG
	perror (pathname);
#endif
	return (-1);
    }

    if (fd >= FD_SETSIZE)		/* not worth making it work here */
    {
	(void) close (fd);
	errno = EMFILE;
	return (-1);
    }

    /* set up filter */

    if (type != ETHER_ALLTYPES)		/* hack for NIT features */
    {
	if (type > ETHER_MAXTYPE)
	{
	    (void) close (fd);
	    errno = EINVAL;
	    return (-1);
	}


	fptr = &filter.Pf_Filter[0];

	*fptr++ = ENF_PUSHWORD + ETHER_TYPE / sizeof (short);
	*fptr++ = ENF_PUSHLIT | ENF_EQ;
	*fptr++ = htons ((u_short) type);

	filter.Pf_FilterLen = fptr - &filter.Pf_Filter[0];

	if (eiocsetf (fd, &filter) < 0)
	    return (-1);
    }

    if (address != 0)
    {
	if (ether_cmp (address, &promiscuous))
	{
#if !defined(MULTICAST) && defined(PROMISCUOUS)
	    ether_addr local_addr;
#endif
	    if (!ETHER_MCAST (address))
	    {
#ifdef DEBUG
		(void) printf ("rejecting non-multicast address argument\n");
#endif
		(void) close (fd);
		errno = EINVAL;
		return (-1);
	    }

#ifdef MULTICAST
	    /* #error not clear how to set multicast addresses */
	    exit (-1);			/* die die die */
#else
#ifdef PROMISCUOUS

	    /*
	     * Enable address matching filter before we go into promiscuous
	     * mode.
	     */

	    (void) ether_address (fd, &local_addr);

	    fptr = &filter.Pf_Filter[0];

	    if (type != ETHER_ALLTYPES)	/* hack for NIT features */
	    {
		*fptr++ = ENF_PUSHWORD + ETHER_TYPE / sizeof (short);
		*fptr++ = ENF_PUSHLIT;
		*fptr++ = htons (type);	/* should be in host order */
		*fptr++ = ENF_CAND;
	    }

	    for (i = 0; i < 3; i++)	/* compare addresses in 3 shorts */
	    {
		*fptr++ = ENF_PUSHWORD + ETHER_DST / sizeof (short) + i;
		*fptr++ = ENF_PUSHLIT | ENF_EQ;
		*fptr++ = ((short *) address)[i];
		*fptr++ = ENF_PUSHWORD + ETHER_DST / sizeof (short) + i;
		*fptr++ = ENF_PUSHLIT | ENF_EQ;
		*fptr++ = ((short *) &ether_bcast_addr)[i];
		*fptr++ = ENF_OR;
		*fptr++ = ENF_PUSHWORD + ETHER_DST / sizeof (short) + i;
		*fptr++ = ENF_PUSHLIT | ENF_EQ;
		*fptr++ = ((short *) &local_addr)[i];
		*fptr++ = ENF_CNOR;
	    }

	    filter.Pf_FilterLen = fptr - &filter.Pf_Filter[0];

	    if (eiocsetf (fd, &filter) < 0)
		return (-1);
#else
#ifdef DEBUG
	    (void) printf ("rejecting multicast address argument\n");
#endif
	    (void) close (fd);
	    errno = EINVAL;
	    return (-1);

#endif					/* PROMISCUOUS */

#endif					/* MULTICAST */

	}

#ifdef MULTICAST
	else				/* only promiscuous if requested */
# endif
	{				/* go into promiscuous mode */

#ifdef PROMISCUOUS
	    /* #error not clear how to set promiscuous mode */
	    exit (-1);			/* die die die */
#else
#ifdef DEBUG
	    (void) printf ("rejecting promiscuous address argument\n");
#endif
	    (void) close (fd);
	    errno = EINVAL;
	    return (-1);

#endif					/* PROMISCUOUS */

	}
    }

    _ether_newaddr (fd);
    ether_type = type;
    return (fd);
}
