/* $Id: dliwritev.c,v 2.1 89/10/23 15:42:10 dupuy Exp $ */

#include <sys/param.h>			/* NOFILE */
#include <sys/socket.h>			/* sockaddr_dl (sockaddr) */
#include <sys/uio.h>			/* iovec */

#include <net/if.h>			/* ifdevea */
#include <netinet/in.h>			/* (ether_header) (in_addr) */
#include <netinet/if_ether.h>		/* sockaddr_dl (ether_header) */
#include <netdnet/dli_var.h>		/* sockaddr_dl */

#include <errno.h>			/* EWOULDBLOCK */

#include "libether.h"

extern struct sockaddr_dl _ether_sockaddrs[NOFILE];

#define sad (_ether_sockaddrs[fd])

/*
 * Writes a single packet, filling src and type fields.
 */

int
ether_writev (fd, packet)
int fd;
ether_vec *packet;
{
    struct msghdr msg;
    int result;

    bcopy ((char *) &packet->dest,
	   (char *) sad.choose_addr.dli_eaddr.dli_target, DLI_EADDRSIZE);

    msg.msg_iov = packet->iov;
    msg.msg_iovlen = packet->iovcnt;
    msg.msg_name = (caddr_t) &sad;
    msg.msg_namelen = sizeof (sad);
    msg.msg_accrights = 0;
    msg.msg_accrightslen = 0;

    result = sendmsg (fd, &msg, 0);

    if (result < 0 && errno == EWOULDBLOCK)
	errno = EAGAIN;

    return (result);
}
