/* $Id: dliaddr.c,v 2.0 89/10/20 19:01:26 dupuy Exp $ */

#include <sys/param.h>			/* NOFILE */
#include <sys/ioctl.h>			/* ioctl */
#include <sys/socket.h>			/* sockaddr_dl (sockaddr) */

#include <net/if.h>			/* ifdevea */
#include <netinet/in.h>			/* (ether_header) (in_addr) */
#include <netinet/if_ether.h>		/* sockaddr_dl (ether_header)  */
#include <netdnet/dli_var.h>		/* sockaddr_dl */

#include "libether.h"

extern struct sockaddr_dl _ether_sockaddrs[NOFILE];

#define sad (_ether_sockaddrs[fd])


static void
devid_to_name (name, devid)
char *name;
struct dli_devid *devid;
{
    register int i;

    for (i = 0; devid->dli_devname[i]; i++)
	name[i] = devid->dli_devname[i];

    name[i++] = '0' + devid->dli_devnumber;

    name[i] = '\0';
}


/*
 * Returns the local ethernet address for the ethernet interface on the file
 * descriptor fd.  The result is stored in the structure given by address; if
 * none is given, malloc is used to allocate space.
 */

ether_addr *
ether_address (fd, address)
int fd;
ether_addr *address;
{
    struct ifdevea ifd;

    devid_to_name (ifd.ifr_name, &sad.dli_device);

    if (ioctl (fd, SIOCRPHYSADDR, (char *) &ifd) < 0)
    {
#ifdef DEBUG
	perror ("ether_address: ioctl SIOCRPHYSADDR");
#endif
	return (0);
    }

    if (address == 0)
	address = (ether_addr *) malloc (sizeof (ether_addr));

    if (address != 0)
	bcopy ((char *) ifd.current_pa, (char *) address, sizeof (ether_addr));

    return (address);
}
