/*
 * PingLogger 1.0 - By, Jeff Thompson(jwthomp@uiuc.edu)
 * 
 * Compiled and tested under Linux 1.2.13
 *
 * Insert standard disclaimer
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <time.h>

/*
 * Location to store logging information.
 */
#define LOG "/var/adm/ping.log"

main()
{
FILE *fp;
int l, i, j;
int sock, length;
struct sockaddr_in name;
char buf[1024];
int code, type;
time_t t;
char *tim;

/* 
 * Open a raw icmp socket in order to receive all ICMP packets
 */
sock = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP);

if (sock < 0) 
    {
    printf("Cannot open Raw ICMP Socket.\n");
    exit(1);
    }

/*
 * Set up the sockaddr structure
 */
name.sin_family = AF_INET;
name.sin_addr.s_addr = INADDR_ANY;
name.sin_port = 0;

/*
 * Bind the socket
 */
if (bind(sock, (struct sockaddr *) &name, sizeof name ) < 0) 
        {
        printf("Error binding ICMP socket");
        exit(1);
        }

length = sizeof(name);

if (getsockname(sock, (struct sockaddr *) &name, &length) < 0)
    {
    printf("Error: Can't get socket name\n");
    exit(1);
    }

printf("PingLogger 1.0 - By, Jeff Thompson started.\n");


/* 
 * Main loop
 */

for( ; ; )
    {
    if ((l = read(sock, buf, 1024)) < 0)
        printf("Error receiving ICMP packet\n");


/*
 * grab ICMP type and code from buffer
 */
type = buf[20] & 0xff;
code = buf[21] & 0xff;

/*
 * Checks if this ICMP packet is an ICMP ECHO REQUEST
 */
if(type == 8 && code == 0)
    {
    fp = fopen(LOG, "a+");
    t = time(NULL);
    tim = ctime(&t);
    /*
     * Get rid of the year and the end of line
     */
    tim[strlen(tim) - 6] = '\0';
    fprintf(fp, "%s: ICMP Echo Request Received From: %d.%d.%d.%d\n", tim,
            buf[12] & 0xff, buf[13] & 0xff, buf[14] & 0xff, buf[15] & 0xff);
    fclose(fp);
    }
  }

close(sock);
exit(0);
}

