#include<sys/types.h>
#include<sys/socket.h>
#include <rpc/rpc.h>
#include<net/if.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/udp.h>
#include<netinet/if_ether.h>
#include<rpc/types.h>
#include<sys/param.h>
#include<sys/time.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <sys/ioctl.h>

#include <signal.h>
#include<netdb.h>
#include "rpcspy.h"
#include <sys/stropts.h>
#include<net/packetfilt.h>
#include <stdio.h>


int dropped=0;
int pr=0;
extern int ok, call, fgc;
long secs;	/* current time in secs */
int ser;	/* packets this second */
int clk();
int die();

struct packetfilt filt = {
	10, 4,
	ENF_PUSHWORD + 6,
	ENF_PUSHLIT, 0x0800,
	ENF_EQ
};


char pint[64];

net_open(interface)
     char *interface;
{
	int efd;
	unsigned long bits;
	int one=1;
	unsigned int back=32;
	struct strioctl si;
	struct ifreq ifr;
	unsigned long sl=0;
	struct timeval to;

	strcpy(pint,interface);
	if ((efd=open("/dev/nit",O_RDONLY)) <0) {
		return(efd);
	}
	/* install filter */
	if (ioctl(efd,I_PUSH,"pf")<0)
		return -1;
	si.ic_cmd=NIOCSETF;
	si.ic_len=sizeof filt;
	si.ic_dp= (char *)&filt;
	if (ioctl(efd,I_STR,&si)<0)
		return -1;
	ioctl(efd,I_SRDOPT,RMSGD); 
	si.ic_timout=INFTIM;
	strcpy(ifr.ifr_name,interface);
	si.ic_cmd=NIOCBIND;
	si.ic_len=sizeof ifr;
	si.ic_dp= (char *)&ifr;
	if (ioctl(efd,I_STR,&si)<0)
		return -1;
	to.tv_sec=0;
	to.tv_usec=0;
	si.ic_cmd=NIOCSSNAP;
	si.ic_len=sizeof sl;
	si.ic_dp=(char *)&sl;
	if (ioctl(efd,I_STR,&si)<0)
		return -1;
	bits =
#ifdef STAMPS
		NI_TIMESTAMP | NI_DROPS |
#endif
		NI_PROMISC ;
	si.ic_cmd=NIOCSFLAGS;
	si.ic_len=sizeof bits;
	si.ic_dp=(char *)&bits;
	if (ioctl(efd,I_STR,&si)<0)
		return -1;
        signal(SIGINT, die);
        signal(SIGHUP, die);
	ioctl(efd,I_FLUSH,FLUSHR);
	return efd;
}

net_read(efd,buf,len)
     int efd;
     ether_packet *buf;
     int len;
{
	int r;
	char *cp;
	struct timeval tv;
	struct timezone tvp;

	r=read(efd,buf,len);
	if (r<0)
		return r;
#ifdef STAMPS
	cp=(char *)buf;
	secs=((struct nit_iftime *)cp)->nh_timestamp.tv_sec;
	ser=((struct nit_iftime *)cp)->nh_timestamp.tv_usec;
	cp += sizeof(struct nit_iftime);
	dropped = ((struct nit_ifdrops *)cp)->nh_drops;
#else /* for screwed up timestamps */

	gettimeofday(&tv,&tvp);
	secs=tv.tv_sec;
	ser=tv.tv_usec;
	/* fprintf(stderr,"%d %d %d\n",secs,ser,dropped); */
#endif
	pr++;
	return r;
}



die()
{
	printf("\n# flush (processed = %d, dropped = %d, call=%d, ok=%d, fgc=%d)\n",
	pr,dropped,call,ok,fgc);
	exit(0);
}
