#include <sys/types.h>
#include <sys/file.h>

#define RFS_NULL        0
#define RFS_GETATTR     1
#define RFS_SETATTR     2
#define RFS_ROOT        3
#define RFS_LOOKUP      4
#define RFS_READLINK    5
#define RFS_READ        6
#define RFS_WRITECACHE  7
#define RFS_WRITE       8
#define RFS_CREATE      9
#define RFS_REMOVE      10
#define RFS_RENAME      11
#define RFS_LINK        12
#define RFS_SYMLINK     13
#define RFS_MKDIR       14
#define RFS_RMDIR       15
#define RFS_READDIR     16
#define RFS_STATFS      17
#define RFS_NPROC       18

typedef struct line {
	int op;		/* RFS_* */
	int stat;	/* OK or FAILED */
	char *time;	/* timestamp */
	char *svr;	/* server */
	char *cln; 	/* client, (including uid) */
	struct {
		char *handle1;
		char *name1;
		char *handle2;
		char *name2;
		char *uid;
		char *mode;
		char *size;
		char *offset;
		char *count;
	} call;
	struct {
		char *handle;
		char *name;
		char *count;
		char *uid;
		char *mode;
		char *size;
	} reply;
} line;

extern line l;
