%{
char *unstring();
%}
%%
[ \t]		;

\n		{ return NL; }

\|		{ return FS; }

"{"		{ return OPEN; }
"}"		{ return CLOSE; }

","		{ return COMMA; }

\#([^\n])*	{ yylval=addstring(yytext);
		  return COMMENT; }

"ok"		{ return OK; }
"failed"	{ return FAILED; }
"null"		{ return PROC_NULL; }
"getattr"	{ return PROC_GETATTR; }
"setattr"	{ return PROC_SETATTR; }
"root"		{ return PROC_ROOT; }
"lookup"	{ return PROC_LOOKUP; }
"readlink"	{ return PROC_READLINK; }
"read"		{ return PROC_READ; }
"writecache"	{ return PROC_WRITECACHE; }
"write"		{ return PROC_WRITE; }
"creat"		{ return PROC_CREAT; }
"remove"	{ return PROC_REMOVE; }
"rename"	{ return PROC_RENAME; }
"link"		{ return PROC_LINK; }
"symlink"	{ return PROC_SYMLINK; }
"mkdir"		{ return PROC_MKDIR; }
"rmdir"		{ return PROC_RMDIR; }
"readdir"	{ return PROC_READDIR; }
"statfs"	{ return PROC_STATFS; }

\"(([^\"\n])|(\\[.\n]))*\"	{ yylval=addstring(unstring(yytext));
			  return STRING; }
([^ \t\n,#\{\}\|])*	{ yylval=addstring(yytext);
			  return STRING; }
%%

/*
 * good enough
 */
char *unstring(s)
     char *s;
{
	static char buf[2048];
	int i;

	i=0;
	for (i=0; *s; s++) {
		if (*s == '"')
			continue;
		if (*s == '\\')
			s++;
		buf[i++] = *s;
	}
	buf[i]='\0';
	return buf;
}
