/* NFS XDR decoding functions
 * Matt Blaze
 * Copyright 1991 Matt Blaze.
 * May be freely reproduced for non-commerical use.
 * All other rights, including use for direct commerical advantage or
 * use in a commerical product, are reserved by the author. 
 * 
 *
 * Note: these are not complete - just enough for rpcspy.
 * In particular, a lot of the data pointers are never filled in,
 * and many functions are decode-only.
 * If you want to use this for a real nfs client or server, you'll need to
 * change the readreply, writeargs, directory reply and statfs functions.
 * If it's going to be in the kernel, you probably will need to change things
 * to deal with mbufs as well.
 * These functions are probably too slow for serious use.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <nfs/nfs.h>
#include <netinet/in.h>

bool_t xdr_fattr();
bool_t xdr_drok ();
bool_t xdr_srok ();
bool_t xdr_rrok ();

struct xdr_discrim d_attrstat[2] = {
	{NFS_OK, xdr_fattr},{__dontcare__, NULL}};

xdr_attrstat(xp, as)
     XDR *xp;
     struct nfsattrstat *as;
{
	return(xdr_union(xp, &as->ns_status, &as->ns_attr,
			 d_attrstat,NULL));
}

xdr_creatargs(xp,ca)
     XDR *xp;
     struct nfscreatargs *ca;
{
	return(xdr_diropargs(xp, &ca->ca_da) &&
	       xdr_sattr(xp, &ca->ca_sa));
}

xdr_diropargs(xp,da)
     XDR *xp;
     struct nfsdiropargs *da;
{
	return(xdr_fhandle(xp, &da->da_fhandle) &&
	       xdr_string(xp, &da->da_name,NFS_MAXNAMLEN));
}

struct xdr_discrim d_diropres[2]={
	{NFS_OK, xdr_drok},
	{__dontcare__,NULL}};

xdr_diropres(xp,dr)
     XDR *xp;
     struct nfsdiropres *dr;
{
	return (xdr_union(xp,&dr->dr_status, &dr->dr_drok,
			  d_diropres, NULL));
}

xdr_drok(xp,dok)
     XDR *xp;
     struct nfsdrok *dok;
{
	return(xdr_fhandle(xp,&dok->drok_fhandle) &&
	       xdr_fattr(xp,&dok->drok_attr));
}

xdr_fattr(xp,fa)
     XDR *xp;
     struct nfsfattr *fa;
{
	return(xdr_enum(xp,&fa->na_type) &&
	       xdr_u_long(xp,&fa->na_mode)&&
	       xdr_u_long(xp,&fa->na_nlink)&&
	       xdr_u_long(xp,&fa->na_uid)&&
	       xdr_u_long(xp,&fa->na_gid)&&
	       xdr_u_long(xp,&fa->na_size)&&
	       xdr_u_long(xp,&fa->na_blocksize)&&
	       xdr_u_long(xp,&fa->na_rdev)&&
	       xdr_u_long(xp,&fa->na_blocks)&&
	       xdr_u_long(xp,&fa->na_fsid)&&
	       xdr_u_long(xp,&fa->na_nodeid)&&
	       xdr_timeval(xp,&fa->na_atime)&&
	       xdr_timeval(xp,&fa->na_mtime)&&
	       xdr_timeval(xp,&fa->na_ctime));
}

xdr_fhandle(xp, fh)
     XDR *xp;
     fhandle_t *fh;
{
	return(xdr_opaque(xp,fh,NFS_FHSIZE));
}

xdr_linkargs(xp, la)
     XDR *xp;
     struct nfslinkargs *la;
{
	return(xdr_fhandle(xp, &la->la_from) &&
	       xdr_diropargs(xp, &la->la_to));
}

xdr_rddirargs(xp, ra)
     XDR *xp;
     struct nfsrddirargs *ra;
{
	return (xdr_fhandle(xp, &ra->rda_fh) &&
		xdr_u_long(xp, &ra->rda_offset)&&
		xdr_u_long(xp, &ra->rda_count));
}

/* this is incomplete! just decodes the status. no put function, either */
xdr_getrddirres(xp, rr)
     XDR *xp;
     struct nfsrddirres *rr;
{
	return(xdr_enum(xp, &rr->rd_status));
}


struct xdr_discrim d_rdlnres[2]={
	{NFS_OK, xdr_srok},
	{__dontcare__,NULL}};

xdr_rdlnres(xp, rr)
     XDR *xp;
     struct nfsrdlnres *rr;
{
	return (xdr_union(xp, &rr->rl_status, &rr->rl_srok,
			  d_rdlnres, NULL));
}

struct xdr_discrim d_rdres[2]={
	{NFS_OK, xdr_rrok},
	{__dontcare__,NULL}};

xdr_rdresult(xp, rr)
     XDR *xp;
     struct nfsrdresult *rr;
{
	return(xdr_union(xp, &rr->rr_status, &rr->rr_ok,
			 d_rdres, NULL));
}

xdr_readargs(xp, ra)
     XDR *xp;
     struct nfsreadargs *ra;
{
	return (xdr_fhandle(xp, &ra->ra_fhandle)&&
		xdr_long(xp, &ra->ra_offset)&&
		xdr_long(xp, &ra->ra_count)&&
		xdr_long(xp, &ra->ra_totcount));
}

xdr_rnmargs(xp, ra)
     XDR *xp;
     struct nfsrnmargs *ra;
{
	return (xdr_diropargs(xp, &ra->rna_from) &&
		xdr_diropargs(xp, &ra->rna_to));
}




/* this isn't complete.  doesnt fill in the data field */
xdr_rrok(xp, rok)
     XDR *xp;
     struct nfsrrok *rok;
{
	return (xdr_fattr(xp, &rok->rrok_attr) &&
		xdr_int(xp, &rok->rrok_count));
	/* should fill in count bytes of data to be complete */
}

xdr_saargs(xp, sa)
     XDR *xp;
     struct nfssaargs *sa;
{
	return(xdr_fhandle(xp, &sa->saa_fh)&&
	       xdr_sattr(xp, &sa->saa_sa));
}

xdr_sattr(xp, sa)
     XDR *xp;
     struct nfssattr *sa;
{
	return (xdr_u_long(xp, &sa->sa_mode)&&
		xdr_u_long(xp, &sa->sa_uid)&&
		xdr_u_long(xp, &sa->sa_gid)&&
		xdr_u_long(xp, &sa->sa_size)&&
		xdr_timeval(xp, &sa->sa_atime)&&
		xdr_timeval(xp, &sa->sa_mtime));
}

xdr_slargs(xp,sa)
     XDR *xp;
     struct nfsslargs *sa;
{
	return (xdr_diropargs(xp, &sa->sla_from)&&
		xdr_string(xp, &sa->sla_tnm, NFS_MAXPATHLEN)&&
		xdr_sattr(xp, &sa->sla_sa));
}

xdr_srok(xp, sr)
     XDR *xp;
     struct nfssrok *sr;
{
	return (xdr_bytes(xp, &sr->srok_data,
			  &sr->srok_count, NFS_MAXPATHLEN));
}

xdr_timeval(xp, tv)
     XDR *xp;
     struct timeval *tv;
{
	return (xdr_long(xp, &tv->tv_sec)&&
		xdr_long(xp, &tv->tv_usec));
}

/* this is incomplete! does not fill in data field */
xdr_writeargs(xp, wa)
     XDR *xp;
     struct nfswriteargs *wa;
{
	return(xdr_fhandle(xp, &wa->wa_fhandle)&&
	       xdr_long(xp, &wa->wa_begoff)&&
	       xdr_long(xp, &wa->wa_offset)&&
	       xdr_long(xp, &wa->wa_totcount)&&
	       xdr_long(xp, &wa->wa_count)); 	/* should be xdr_bytes */
}


/* this is incomplete! just checks the return status */
xdr_statfs(xp, fs)
     XDR *xp;
     struct nfsstatfs *fs;
{
	return(xdr_enum(xp, &fs->fs_status));
}
