%{
/*
 * YACC Grammar for nfstrace
 * 11/91
 * Copyright 1991 Matt Blaze.
 * May be freely reproduced for non-commerical use.
 * All other rights, including use for direct commerical advantage or
 * use in a commerical product, are reserved by the author.
 */
#include <stdio.h>
#include "nfsstuff.h"

line l;

typedef char str[1024];
#define NFIELDS 64

str strings[NFIELDS];

int field=0;
int nfields;
extern FILE *fd;

%}

%token NL FS OPEN CLOSE COMMA
%token OK FAILED
%token PROC_NULL PROC_GETATTR PROC_SETATTR PROC_ROOT PROC_LOOKUP PROC_READLINK PROC_READ
%token PROC_WRITECACHE PROC_WRITE PROC_CREAT PROC_REMOVE PROC_RENAME PROC_LINK
%token PROC_SYMLINK PROC_MKDIR PROC_RMDIR PROC_READDIR PROC_STATFS
%token STRING COMMENT

%start lines

%%


lines	:
	| lines line
	;

line	: NL
	| COMMENT NL			{ fprintf(fd,"#%s\n",strings[$1]);
					   fflush(fd);
					   reset(); }
	| op NL				{ do_operation();reset(); }
	| error NL			{ fprintf(stderr,"BAD line\n");reset();}
	;

op	: hdr FS proc_null
	| hdr FS proc_getattr
	| hdr FS proc_setattr
	| hdr FS proc_root
	| hdr FS proc_lookup
	| hdr FS proc_readlink
	| hdr FS proc_read
	| hdr FS proc_writecache
	| hdr FS proc_write
	| hdr FS proc_creat
	| hdr FS proc_remove
	| hdr FS proc_rename
	| hdr FS proc_link
	| hdr FS proc_symlink
	| hdr FS proc_mkdir
	| hdr FS proc_rmdir
	| hdr FS proc_readdir
	| hdr FS proc_statfs
	;

hdr	: timestamp FS server FS client { l.time = strings[$1];
					  l.svr = strings[$3];
					  l.cln = strings[$5]; }
	;

timestamp : STRING			{ $$ = $1; }
	;

server	: STRING			{ $$ = $1; }
	;

client	: STRING			{ $$ = $1; }
	;

proc_null : PROC_NULL FS call_null FS reply_null
					{ l.op = RFS_NULL; }
	;

proc_getattr : PROC_GETATTR FS call_getattr FS reply_getattr
					{ l.op = RFS_GETATTR; }
	;

proc_setattr : PROC_SETATTR FS call_setattr FS reply_setattr
					{ l.op = RFS_SETATTR; }
	;

proc_root : PROC_ROOT FS call_root FS reply_root
					{ l.op = RFS_ROOT; }
	;

proc_lookup : PROC_LOOKUP FS call_lookup FS reply_lookup
					{ l.op = RFS_LOOKUP; }
	;

proc_readlink : PROC_READLINK FS call_readlink FS reply_readlink
					{ l.op = RFS_READLINK; }
	;

proc_read : PROC_READ FS call_read FS reply_read
					{ l.op = RFS_READ; }
	;

proc_writecache : PROC_WRITECACHE FS call_writecache FS reply_writecache
					{ l.op = RFS_WRITECACHE;}
	;

proc_write : PROC_WRITE FS call_write FS reply_write	
					{ l.op = RFS_WRITE; }
	;

proc_creat : PROC_CREAT FS call_creat FS reply_creat
					{ l.op = RFS_CREATE; }
	;

proc_remove : PROC_REMOVE FS call_remove FS reply_remove
					{ l.op = RFS_REMOVE; }
	;

proc_rename : PROC_RENAME FS call_rename FS reply_rename
					{ l.op = RFS_RENAME; }
	;

proc_link : PROC_LINK FS call_link FS reply_link
					{ l.op = RFS_LINK; }
	;

proc_symlink : PROC_SYMLINK FS call_symlink FS reply_symlink
					{ l.op = RFS_SYMLINK; }
	;

proc_mkdir : PROC_MKDIR FS call_mkdir FS reply_mkdir
					{ l.op = RFS_MKDIR; }
	;

proc_rmdir : PROC_RMDIR FS call_rmdir FS reply_rmdir
					{ l.op = RFS_RMDIR; }
	;

proc_readdir : PROC_READDIR FS call_readdir FS reply_readdir
					{ l.op = RFS_READDIR; }
	;

proc_statfs : PROC_STATFS FS call_statfs FS reply_statfs
					{ l.op = RFS_STATFS; }
	;


call_null :
	;

reply_null :
	;

call_getattr : fhandle			{ l.call.handle1 = strings[$1]; }
	;

reply_getattr : FAILED			{ l.stat = 0; }
	| OK COMMA fattr		{ l.stat = 1; }
	;

call_setattr : OPEN fhandle COMMA sattr CLOSE { l.call.handle1 = strings[$2]; }
	;

reply_setattr : FAILED			{ l.stat = 0; }
	| OK COMMA fattr		{ l.stat = 1; }
	;

call_root :
	;

reply_root :
	;

call_lookup : diropargs
	;

reply_lookup : FAILED			{ l.stat = 0; }
	| OK COMMA diropres		{ l.stat = 1; }
	;

call_readlink : fhandle			{ l.call.handle1 = strings[$1]; }
	;

reply_readlink : FAILED			{ l.stat = 0; }
	| OK COMMA STRING		{ l.stat = 1;
					  l.reply.name = strings[$2]; }
	;

call_read : OPEN fhandle COMMA STRING COMMA STRING CLOSE 	{
					l.call.handle1 = strings[$2];
					l.call.offset = strings[$4];
					l.call.count = strings[$6]; }
	;

reply_read : FAILED			{ l.stat = 0; }
	| OK COMMA STRING		{ l.stat = 1;
					  l.reply.count = strings[$3]; }

call_writecache :
	;

reply_writecache :
	;

call_write : OPEN fhandle COMMA STRING COMMA STRING CLOSE 	{
					l.call.handle1 = strings[$2];
					l.call.offset = strings[$4];
					l.call.count = strings[$6]; }
	;

reply_write : FAILED			{ l.stat = 0; }
	| OK COMMA fattr		{ l.stat = 1; }
	;

call_creat : OPEN fhandle COMMA STRING COMMA sattr CLOSE 	{
					l.call.handle1 = strings[$2];
					l.call.name1 = strings[$4]; }
	;

reply_creat : FAILED			{ l.stat = 0; }
	| OK COMMA OPEN fhandle COMMA fattr CLOSE 	{
					l.stat = 1;
					l.reply.handle = strings[$4]; }
	;

call_remove : diropargs
	;

reply_remove : FAILED			{ l.stat = 0; }
	| OK				{ l.stat = 1; }
	;

call_rename : diropargs COMMA diropargs2
	;

reply_rename: FAILED			{ l.stat = 0; }
	| OK				{ l.stat = 1; }
	;

call_link : OPEN fhandle COMMA diropargs2 CLOSE {
					l.call.handle1 = strings[$2]; }
	;

reply_link : FAILED			{ l.stat = 0; }
	| OK				{ l.stat = 1; }
	;

call_symlink : OPEN diropargs COMMA STRING COMMA sattr CLOSE {
					l.call.name2 = strings[$4]; }
	;

reply_symlink : FAILED			{ l.stat = 0; }
	| OK				{ l.stat = 1; }
	;

call_mkdir : OPEN fhandle COMMA STRING COMMA sattr CLOSE {
					l.call.handle1 = strings[$2];
					l.call.name1 = strings[$4]; }
	;

reply_mkdir : FAILED			{ l.stat = 0; }
	| OK COMMA OPEN fhandle COMMA fattr CLOSE  {
					l.stat = 1;
					l.reply.handle = strings[$4]; }
	;

call_rmdir : diropargs
	;

reply_rmdir : FAILED			{ l.stat = 0; }
	| OK				{ l.stat = 1; }
	;

call_readdir : fhandle
	;

reply_readdir : FAILED
	| OK
	;

call_statfs :
	;

reply_statfs :
	;

fhandle : STRING			{ $$ = $1; }
	;

diropargs : OPEN fhandle COMMA STRING CLOSE {
					l.call.handle1 = strings[$2];
					l.call.name1 = strings[$4]; }
	;

diropargs2 : OPEN fhandle COMMA STRING CLOSE {
					l.call.handle2 = strings[$2];
					l.call.name2 = strings[$4]; }
	;

fattr : OPEN STRING COMMA STRING COMMA STRING COMMA STRING CLOSE {
					l.reply.mode = strings[$2];
					l.reply.uid = strings[$4];
					l.reply.size = strings[$6]; }
	;

sattr : OPEN STRING COMMA STRING COMMA STRING CLOSE {
					l.call.mode = strings[$2];
					l.call.uid = strings[$4];
					l.call.size = strings[$6]; }
	;

diropres : OPEN fhandle COMMA fattr CLOSE {
					l.reply.handle = strings[$2]; }
	;


%%
addstring(s)
     char *s;
{
	strcpy(strings[field],s);
	strings[field];
	return (field++);
}

reset()
{
	field=0;
}


#include "lex.yy.c"
