#include <stdio.h>
#include "packet.h"

in_cksum(addr, len)
u_short *addr;
int len;
{
        register int nleft = len;
        register u_short *w = addr;
        register u_short answer;
        register int sum = 0;

        while (nleft > 1)  {
                sum += *w++;
                nleft -= 2;
        }

        if (nleft == 1)
                sum += *(u_char *)w;

        sum = (sum >> 16) + (sum & 0xffff);     /* add hi 16 to low 16 */
        sum += (sum >> 16);                     /* add carry */
        answer = ~sum;                          /* truncate to 16 bits */
        return (answer);
}

gen_ip_hdr(packet, src_addr, dst_addr, ip_id, packet_size)
struct opacket *packet;
struct in_addr src_addr, dst_addr;
u_short ip_id;
u_short packet_size;
{
	packet->ihdr.ip_hl 	= 5;			/* IP header length in dwords */
	packet->ihdr.ip_v	= IPVERSION;
	packet->ihdr.ip_tos	= DEF_IP_TOS;		/* type of service */
	packet->ihdr.ip_len	= htons(packet_size);	/* overall size of packet */
	packet->ihdr.ip_id	= htons(ip_id);
	packet->ihdr.ip_ttl	= DEF_IP_TTL;
	packet->ihdr.ip_off	= 0;
	packet->ihdr.ip_p	= IPPROTO_TCP;
	packet->ihdr.ip_src	= src_addr;
	packet->ihdr.ip_dst	= dst_addr;
	packet->ihdr.ip_sum	= in_cksum((u_short *) packet, sizeof(struct ip));
	
	return(0);
}

chk_tcp_hdr(packet, src_addr, dst_addr, len)
struct opacket *packet;
struct in_addr src_addr, dst_addr;
short len;
{
	struct ptcphdr *pthdr;
	char *buf;
	
	if((buf = (char *) malloc (sizeof(struct ptcphdr) + len)) == NULL)
		return(-1);

	bzero(buf, sizeof(struct ptcphdr) + len);

	pthdr = (struct ptcphdr *) buf;
	pthdr->src_addr		= src_addr;
	pthdr->dst_addr		= dst_addr;
	pthdr->proto		= IPPROTO_TCP;
	pthdr->tcplen		= htons(len);
	
	bcopy(&packet->thdr, buf + sizeof (struct ptcphdr), len);

	packet->thdr.th_sum	= in_cksum((u_short *) buf, 
				  sizeof(struct ptcphdr) + len);

	free(buf);
	return(0);
}

gen_tcp_pak(packet, src, dst, ip_id, seq_num, ack_num, datalen, flags)
struct opacket *packet;
struct sockaddr_in *src, *dst;
u_short ip_id;
u_long seq_num, ack_num;
u_short datalen;
u_char flags;
{
	bzero(packet, sizeof(struct opacket));

	gen_ip_hdr(packet, src->sin_addr, dst->sin_addr, ip_id,
		   sizeof(struct ip) + sizeof(struct tcphdr) + datalen);

	packet->thdr.th_sport	= src->sin_port;
	packet->thdr.th_dport	= dst->sin_port;
	packet->thdr.th_off	= 5;			/* data offset is 5 */
	packet->thdr.th_win	= htons(DEF_TCP_WIN);

	packet->thdr.th_seq	= htonl(seq_num);
	packet->thdr.th_ack	= htonl(ack_num);
	packet->thdr.th_flags	= flags;

	chk_tcp_hdr(packet, src->sin_addr, dst->sin_addr, 
		    sizeof(struct tcphdr) + datalen);
	return(sizeof(struct tcphdr) + sizeof(struct ip) + datalen);
}
