#ifdef NIT
#include <stdio.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <net/if.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include "netinet/if_ether.h"

#ifndef TEST
#include "dnit.h"
 
extern Nit *nitfd;
#endif

send_pak(packet, pktlen, etheradd)
unsigned char *packet;
unsigned int pktlen;
char *etheradd;
{
	struct ether_header *ehdr;
	static unsigned char buf[2048]; 	/* max ethernet pkt size 
						   is 1536 bytes */
	unsigned int i;

	bzero(buf, 2048);
	ehdr = (struct ether_header *) buf;

	ehdr->ether_type = htons(ETHERTYPE_IP);
	bcopy(etheradd, &ehdr->ether_shost, 6);
	bcopy(etheradd, &ehdr->ether_dhost, 6);
	
	bcopy(packet, &buf[14], pktlen);
	
	/* add zero padding if necesarry */

	if(pktlen & 3)
		pktlen += 4 - (pktlen & 3);
	
#ifdef DEBUG
	hexdump(buf, pktlen + sizeof(struct ether_header));
#endif
	
#ifndef TEST
#ifdef WRITE
	NitWrite(nitfd, buf, sizeof(struct ether_header) + pktlen); 
#endif
#endif
	return(0);
}

char *get_ip_pak(timeout, pktlen)
struct timeval *timeout;
unsigned long *pktlen;
{
#ifndef TEST
	fd_set *fdsptr = NULL;
	struct ether_header *ehdr;
	unsigned long msglen, drops;
	struct timeval timestamp;
	unsigned char *p;

	*pktlen = 0;
	if(NitCheck(nitfd, timeout, &fdsptr)) {
		p = NitRead(nitfd, &msglen, pktlen, &timestamp, &drops);
		if (p == NULL) {
			*pktlen = 0;
			return(NULL);
		}
		ehdr = (struct ether_header *) p;
		if (ehdr->ether_type != ETHERTYPE_IP) {
			*pktlen = -1;
			return(NULL);
		}
		p += sizeof(struct ether_header);
		return((char *) p);
	}
	else {
		*pktlen = 0;
		return(NULL);
	}
#endif
}
#endif
