#ifdef NIT
#include <stdio.h>
#include <limits.h>
#include <memory.h>
#include <string.h>
#include <stropts.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <net/if.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/nit_buf.h>

#include "dnit.h" 

Nit* NewNit();
void DelNit();

unsigned char  NitInit(argc,argv)
int argc;
char *argv[];
{
    return(1);
}


Nit *NitOpen(interface,bufsize,snaplen,timeout,flags)
char *interface;
ulong  bufsize,snaplen,flags;
struct timeval timeout;
{   
  Nit *nit;          
  struct strioctl si;
  struct ifreq ifr;

    if ((nit = NewNit()) == NULL)    
    {
        fprintf(stderr,"nit: memory allocation failed");
        return NULL;
    }

    if ((nit->fd = open(NITDEVICE, O_RDWR)) < 0)
    {
        fprintf(stderr,"nit: open failed\n");
        NitClose(nit);
        return NULL;
    }

    if ((nit->interface = (char *) malloc(strlen(interface)+1)) == NULL)
    {
	fprintf(stderr,"nit: memory allocation failed\n");
    	NitClose(nit);
	return NULL;
    }
	
    if ((nit->buf = (BYTE *)malloc(bufsize)) == NULL)
    {
	fprintf(stderr,"nit: memory allocation failed\n");
       	NitClose(nit);
	return NULL;
    }
	
    /*  arrange to get discrete messages from the stream  */
    if (ioctl(nit->fd, I_SRDOPT, (VOID *)RMSGD) < 0)
    {
	fprintf(stderr,"nit: discrete message option set failed\n");
     	NitClose(nit);
	return NULL;
     }
    
    /*  setting of options are allowed to take a long time  */      
    si.ic_timout = INFTIM;
                   
    /*  push and configure the filtering module  */
    if (ioctl(nit->fd, I_PUSH, NITFILTER) < 0)
    {
	fprintf(stderr,"nit: 'pf' push failed\n");
     	NitClose(nit);
	return NULL;
    }
    
    /*  push and configure the buffering module  */
    if (ioctl(nit->fd, I_PUSH, NITBUFFER) < 0)
    {
	fprintf(stderr,"nit: 'nbuf' push failed\n");
        NitClose(nit);
	return NULL;
    }
    
    si.ic_cmd = NIOCSCHUNK;
    si.ic_len = sizeof(bufsize);
    si.ic_dp = (VOID *)&bufsize;
    if (ioctl(nit->fd, I_STR, (VOID *)&si) < 0)
    {
	fprintf(stderr,"nit: chunksize option set failed\n");
    	NitClose(nit);
	return NULL;
    }

	/*  timeout settings must come after bufsize settings:
	 *  if timeout == 0 then bufsize is reset too
	 */
    si.ic_cmd = NIOCSTIME;
    si.ic_len = sizeof(timeout);
    si.ic_dp = (VOID *)&timeout;
    if (ioctl(nit->fd, I_STR, (VOID *)&si) < 0)
    {
	fprintf(stderr,"nit: timeout option set failed\n");
    	NitClose(nit);
	return NULL;
    }
    
    memset(ifr.ifr_name, 0, sizeof(ifr.ifr_name));
    strncpy(ifr.ifr_name, interface, sizeof(ifr.ifr_name));
    ifr.ifr_name[sizeof(ifr.ifr_name)-1] = '\0';
    si.ic_cmd = NIOCBIND;
    si.ic_len = sizeof(ifr);
    si.ic_dp = (VOID *)&ifr;
    if (ioctl(nit->fd, I_STR, (VOID *)&si) < 0)
    {
	fprintf(stderr,"nit: interface bind failed\n");
        NitClose(nit);
	return NULL;
    }
   
    if (snaplen > 0)
    {
        si.ic_cmd = NIOCSSNAP;
        si.ic_len = sizeof(snaplen);
        si.ic_dp = (VOID *)&snaplen;
        if (ioctl(nit->fd, I_STR, (VOID *)&si) < 0)
    	{
		fprintf(stderr,"nit: snapshot length option set failed\n");
        	NitClose(nit);
    		return NULL;
    	}
    }
                                   
    if (flags != 0)
    {
        si.ic_cmd = NIOCSFLAGS;
        si.ic_len = sizeof(flags);
        si.ic_dp = (VOID *)&flags;
        if (ioctl(nit->fd, I_STR, (VOID *)&si) < 0)
    	{
		fprintf(stderr,"nit: flags set failed\n");
        	NitClose(nit);
    		return NULL;
    	}
    }
                                 
	strcpy(nit->interface, interface);
	nit->bufsize = bufsize;
	nit->snaplen = snaplen;
	nit->timeout.tv_sec = timeout.tv_sec;
	nit->timeout.tv_usec = timeout.tv_usec;
	nit->flags = flags;
	nit->pos = 0;
	nit->end = 0;
	
    if (ioctl(nit->fd, I_FLUSH, (VOID *)FLUSHR) < 0)
    {
	fprintf(stderr,"nit: read flush failed\n");
    	NitClose(nit);
	return NULL;
     }
    
    return nit;
}


VOID NitClose(nit)
Nit *nit;
{
    if(!nit) return;
    if (nit->fd != 0)
        close(nit->fd);
    DelNit(nit);
}


int NitCheck(nit,timeout,fds)
Nit *nit;
struct timeval *timeout;
fd_set **fds;
{
static fd_set readfds;
int s;

    if(!nit)
      return(-1);
    if (nit->pos < nit->end)
        return 1;

    if (*fds == NULL)        
    {
        *fds = &readfds;
        FD_ZERO(*fds);
    }
        
    FD_SET(nit->fd, *fds);
    s = select(ulimit(4, 0), *fds, NULL, NULL, timeout);
         
    if (s < 0)
        fprintf(stderr,"nit:  check failed\n");
    
    return s;
}


BYTE *NitRead(nit,msglen,pktlen,timestamp,drops)
Nit *nit;
ulong *msglen,*pktlen,*drops;
struct timeval *timestamp;
{
BYTE *cp;
struct nit_bufhdr *hp;

    if(!nit)
      return(NULL);
    if (!(nit->pos < nit->end))
	    if ((nit->end = read(nit->fd, nit->buf, nit->bufsize)) < 0)
    	    {
                fprintf(stderr,"nit: read failed\n");
		return NULL;
            }
	    else
		nit->pos = 0;
			
    cp = nit->buf+nit->pos;
	
    hp = (struct nit_bufhdr *)cp;      
    *msglen = hp->nhb_msglen;
    cp += sizeof(*hp);
	
    if (nit->flags & NI_TIMESTAMP)
    {
	struct nit_iftime *tp;
	tp = (struct nit_iftime *)cp;
        timestamp->tv_sec = tp->nh_timestamp.tv_sec;
        timestamp->tv_usec = tp->nh_timestamp.tv_usec;
	cp += sizeof(*tp);
    }
	
    if (nit->flags & NI_DROPS)
    {
	struct nit_ifdrops *dp;
	dp = (struct nit_ifdrops *)cp;   
        *drops = dp->nh_drops;
	cp += sizeof(*dp);
    }
	
    if (nit->flags & NI_LEN)
    {
	struct nit_iflen *lp;
	lp = (struct nit_iflen *)cp;          
        *pktlen = lp->nh_pktlen;
	cp += sizeof(*lp);
    }
	
    nit->pos += hp->nhb_totlen;
	
    return cp;
}


int NitWrite(nit,packet,pktlen)
Nit *nit;
BYTE *packet;
ulong pktlen;
{            
struct sockaddr sa; 
struct strbuf ctl, data;
int llhsize = sizeof(sa.sa_data);

    if(!nit)
        return -1;

    if (pktlen > INT_MAX)
        return -1;
        
    sa.sa_family = AF_UNSPEC;
    memcpy(sa.sa_data, packet, llhsize);

    ctl.maxlen = ctl.len = sizeof(sa);
    ctl.buf = (char *)&sa;
    data.maxlen = data.len = pktlen - llhsize;
    data.buf = (char *)packet + llhsize;
    if (putmsg(nit->fd, &ctl, &data, 0) < 0)
    {
        fprintf(stderr,"nit: putmsg failed\n");
        return -1;
    }

    if (ioctl(nit->fd, I_FLUSH, (VOID *)FLUSHW) < 0)
    {
        fprintf(stderr,"nit: write flush failed\n");
        return -1;
    }
        
    return pktlen;
}


Nit* NewNit()
{
Nit *nit;

	if ((nit = (Nit *)malloc(sizeof(Nit))) == NULL)
		return NULL;
		
	nit->fd = 0;		
	nit->interface = NULL;
	nit->bufsize = 0;
	nit->snaplen = 0;
	nit->timeout.tv_sec = 0;
	nit->timeout.tv_usec = 0;
	nit->flags = 0;
	nit->buf = NULL;
	nit->pos = 0;
	nit->end = 0;
	
	return nit;
}


void DelNit(nit)
Nit *nit;
{
    if(!nit)
      return;
    free(nit->buf);
    free(nit->interface);
    free(nit);
}
#endif
