#ifndef _NIT_H
#define _NIT_H

#include <sys/types.h>
#include <sys/time.h>

typedef unsigned short USHORT;
typedef unsigned long  ULONG;
typedef ULONG ulong;
typedef void   VOID;
typedef int    INT;
typedef char   CHAR;
typedef long   LONG;
typedef unsigned char  BYTE;
typedef float  FLOAT;

#define NITDEVICE       "/dev/nit"
#define NITFILTER       "pf"
#define NITBUFFER       "nbuf"

typedef struct _Nit
{
	int             fd;
	char            *interface;
	unsigned short  bufsize;
	unsigned long   snaplen;
	struct timeval  timeout;
	unsigned long   flags;
	unsigned char   *buf;
	long            pos;
	long            end;
} Nit;


unsigned char NitInit(/*int argc, char *argv[]*/);

Nit* NitOpen(/*const CHAR *interface, ULONG bufsize, ULONG snaplen, TIMEVAL timeout, ULONG flags*/);
VOID NitClose(/*Nit *nit*/);

INT NitCheck(/*Nit *nit, TIMEVAL *timeout, fd_set **fds*/);

BYTE *NitRead(/* Nit *nit, ULONG *msglen, ULONG *pktlen, TIMEVAL *timestamp, ULONG *drops */);
INT NitWrite(/* Nit *nit, BYTE *packet, ULONG pktlen */);


#endif

