#ifdef NIT
#include <sys/param.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/sockio.h>
#include <sys/ioctl.h>

#include <netdb.h>
#include <netinet/in.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/if_ether.h>

#include <errno.h>
#include <nlist.h>
#include <kvm.h>
#include <stdio.h>

arp(address,ether)
  char	*address;
  char	*ether;
{
  struct arpreq		ar;
  struct sockaddr_in	*sin;
  u_char		*ea;
  int			s;
  char			*inet_ntoa();

  bzero((caddr_t)&ar, sizeof ar);
  ar.arp_pa.sa_family	= AF_INET;
  sin = (struct sockaddr_in *)&ar.arp_pa;
  sin->sin_family	= AF_INET;
  bcopy(address,&sin->sin_addr.s_addr,4);

  s = socket(AF_INET, SOCK_DGRAM, 0);
  if(s < 0) {
    perror("arp: socket");
    return(-1);
  }
  if(ioctl(s, SIOCGARP, (caddr_t)&ar) < 0) {
    if(errno == ENXIO)
      return(-1);
    else
      perror("SIOCGARP");
    return(-1);
  }
  close(s);
  ea = (u_char *)ar.arp_ha.sa_data;
  bcopy(ar.arp_ha.sa_data,ether,6);  
  return(0);
}
#endif
