#!/usr/bin/perl
#
# logarp.pl
# 
# an ARP watcher in perl
#
# this is ALPHA code!
#
# 6 May 1996  jwa@nbs.nau.edu
#

require 'flush.pl';
require 'sys/socket.ph';

# adjust to your net

$net = "134.114.84";

# "noisy" services increase the CPU time that tcpdump chews; we can
# ignore some of the chatty ones -- in this case, NFS and X.
# (this may defeat the purpose of the program, though!)

$noisy = "and not port 2049 and not port 6000";

# main loop

open (TCPDUMP, "tcpdump -q -e -n src net $net $noisy |") || die "couldn't launch tcpdump: $!\n";

while ($line = <TCPDUMP>) {
 chop $line;

 ($gmt, $srceth, $dsteth, $foo, $srcipp, $dir, $dstipp, $type, $foo) = split(/ /, $line);

 ($a, $b, $c, $d, $sport) = split(/\./, $srcipp);
 $srcip = "$a.$b.$c.$d";
 if ($srcip ne "arp...") {
  #$srcname = get_host_name($srcip);
  if ($srceth ne "0:0:0:0:0:0") {
   #@vendor = getethermf($srceth);
   #print "[$srceth] [$srcip] @vendor\n";
   do_cmp($srceth, $srcip); 
  }
 } 
}

sub do_cmp {
 $eth = shift @_;
 $ip = shift @_;

 # search for eth in list
 # if listip is different from ip then flag
 # else add eth & ip to list

 $listfile = "known-hosts.dat";
 $foundeth = 0;

 open(LIST, "$listfile");
 while ($line = <LIST>) {
  chop $line;
  ($listeth, $listip) = split(/ /, $line);
  if ($eth eq $listeth) {
   $foundeth = 1;
   if ($ip ne $listip) {
    @vendor = getethermf($eth);
    $stamp = &timestamp();
    print "** $stamp CHANGED $eth  old: $listip new: $ip (@vendor)\n";
    flush(STDOUT);
    close (LIST);
    return;
   }
  }
 }
 if ($foundeth == 0) {
  @vendor = getethermf($eth);
  $name=get_host_name ($ip);
  $stamp = &timestamp();
  print "$stamp NEW $eth $name $ip @vendor\n";
  flush(STDOUT);
  open (LIST, ">>$listfile");
  print LIST "$eth $ip\n";
  close(LIST);
 }
}

sub getethermf {
 $ethaddr = shift @_;

 ($a, $b, $c) = split (/:/, $ethaddr);

 $head = "$a:$b:$c";

 open (CODES, "ethercodes.dat") || die "couldn't open ethercodes.dat : $!\n";
 while ($line = <CODES>){ 
  chop $line;
  ($code, @vendor) = split(/ /, $line);
  if ($code eq $head) {
   return @vendor;
  }
 }
 return "???";

}



#
# this code snagged from satan-1.0 (zen & wzv)
#
#  Lookup the FQDN for a host name or address with cacheing.

sub get_host_name {
	local($host) = @_;
	local($aliases, $type, $len, @ip, $a,$b,$c,$d);

	# do cache lookup first
	if (exists($host_name_cache{$host})) {
		return($host_name_cache{$host});
		}

	# if host is ip address
	if ($host =~ /^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/) {
		($a,$b,$c,$d) = split(/\./, $host);
		@ip = ($a,$b,$c,$d);
		($host) = gethostbyaddr(pack("C4", @ip), &AF_INET);
		}
	# if host is name, not ip address
	else {
		($host, $aliases, $type, $len, @ip) = gethostbyname($host);
		($a,$b,$c,$d) = unpack('C4',$ip[0]);
		}

	# success:
	if ($host && @ip) {
		$host =~ tr /A-Z/a-z/;
		return $host_name_cache{$host} = $host;
		}
	# failure:
	else {
		return $host_name_cache{$host} = "";
		}
	}

sub timestamp {

 ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
 $mday = pad($mday,2);
 $mon = pad($mon, 2);
 $mon++;	# ??? bug ???
 $hour = pad($hour, 2);
 $min = pad ($min, 2);
 $mytime = "$mon/$mday $hour:$min";

 return $mytime;

}

# simple routine to pad numbers w/ zeros
# i think i can do this with pack instead.

sub pad
{
 $what = shift @_;
 $countn = shift @_;
 $pad = "";

 $size = length ($what);
 $count = $countn - length ($what);
 $padded = "";
 for ($i=0; $i<$count; $i++) {
  $padded="0$padded";
 }
 $padded = "$padded$what";
 return $padded;
}


