/*
 * network.h
 */

#ifndef __NETWORK_H
#define __NETWORK_H

#include <netinet/in.h>


/*
 * Gets and returns a tcp socket
 */
int get_tcp_socket();

/*
 * Gets and returns a udp socket
 *    Please NOTE that the udp code is not completed.
 */
int get_udp_socket();

/*
 * Connects a tcp socket to another tcp socket found at to
 */
int connect_tcp_socket(int sock, struct sockaddr_in *to);

/*
 * Binds a tcp socket to a port specified by to
 */
int bind_tcp_socket(int sock, struct sockaddr_in *to);

/*
 * Initializes the sockaddr_in structure with the port and addr values
 */
int init_sockaddr(struct sockaddr_in *to, int port, unsigned long addr);

/*
 * Send tcp data out a socket.
 */
int send_data(int sock, char *data);

/*
 * Check for data on a tcp socket.
 *     Returns > 0 : Returns socket number data came through, along with data.
 *     Returns = -1: Error condition.
 *     Returns = -4: Lost connection on socket 'data[0]' data[0] stores socket
 *                   number;
 *     Returns = -5: New connection on socket 'data[0]'
 */
int get_data(int sockfd, char *data, int len, int flag);

/*
 * Initializes sockets table stored in network library.  This table
 * tells the library whether a socket is currently open or not.
 */
void init_sockets();

/*
 * Closes a socket and removes it from the socket_table
 */
int close_socket(int sock);
#endif /* __NETWORK_H */
