#include <stdio.h>
#include <sys/socket.h>
#include <signal.h>

#include "network.h"

/*
 * set_up_server - Takes a port as an argument to start a message
 *                 passing server up on.
 */
int
set_up_server(int port) {
    /*
     * sock - Socket for server
     */
    int sock;

    /* 
     * to - Pointer to a sockaddr_in used in bind call. Holds port information.
     */
    struct sockaddr_in *to;

    /*
     * Mallocs memory and sets the to pointer to point to it.
     */
    to = (struct sockaddr_in *) malloc(sizeof(struct sockaddr_in));

    /*
     * Call to get_tcp_socket which opens a socket and returns the socket
     * number to be stored in sock.
     */
    sock = get_tcp_socket();

    /*
     * Checks for socket error condition.
     */
    if(sock < 0) {
        printf("sock error\n");
        exit(0);
    }

    /*
     * Makes a call to init_sockaddr, which initializes the sockaddr_in
     * structure and returns whether there was an error or not.
     */
    if(init_sockaddr(to, port, INADDR_ANY) < 0) {
        printf("init sock error\n");
        exit(0);
    }

    /*
     * Binds the socket with the parameters in to.
     */
    if(bind_tcp_socket(sock, to) < 0) {
        printf("bind error\n");
        exit(0);
    }

    /*
     * Sets socket to be a listening socket with a queue of 5
     */
    listen(sock, 5); 

    /*
     * Initializes the sockets table in the network library.
     */
    init_sockets();

    /*
     * Return the value of the listening socket 
     */
    return(sock);
}

