
#include <stdio.h>
#include <sys/socket.h>
#include <signal.h>

#include "network.h"
#include "message.h"
#include "chat.h"


void
main(int argc, char *argv[]) {
    int b;		/* Return value of get_data */
    int i;		/* Loop variable */
    int sock;		/* Listen Socket */
    char buf[256];	/* data buffer */
    char c[2];		/* Used to print out id numbers */
    int port = 4040;	/* Port number to be used */
    int ns;		/* Maximum user number */
    struct user LIST[256];	/* An array of user structures */
				/* Yes dynamic allocation would be cooler */
				/* But hey, this is a demo */
    if(argc < 2) {
        printf("%s: port\n", argv[0]);
        exit(0);
    }

    port = atoi(argv[1]);
  
    /*
     * Initializes the user list
     */
    for(i = 0; i < 256; i++) 
        initialize_user(i, LIST);

    /*
     * Starts up a message server.
     */
    sock = set_up_server(port);

    /*
     * Sets maximum socket to Listen Socket 
     */
    ns = sock + 1;

printf("started server on: %d\n", sock);

    /*
     * While loop to keep checking for data and connections.
     */
    while(1) {

        /*
         * Checks if new data came in.
         */
        if( (b = get_data(sock, buf, 255, 1)) > 0 ) {
            filter_ansi(buf);
            parse_message(b, LIST, buf, ns);
            }

        if( b == -5 ) {    /* New Connection */

#ifdef DEBUG
    printf("Server: Got a new connection: %d\n", buf[0]);
#endif /* DEBUG */
            if( buf[0] >= ns) 
                ns++;	/* Increment maximum number of sockets */
            for(i = 0; i < ns; i++)
                if(LIST[i].status == 1) 
                    send_data( i, "SYSTEM MESSAGE: New user has logged on.\n");
            send_data( buf[0], 
                       "\nWelcome to 31337 Chat.\n Type '/help' for help.\n\n");

            activate_user( buf[0], LIST );


        } else if( b == -4 ) { /* Lost a connection */

#ifdef DEBUG
        printf("Lost a connection\n");
#endif /* DEBUG */

            close_socket(buf[0]);

        } else if( b < 0 ) {

            /* Unknown error so exiting. */
            printf("some stupid error\n");
            exit(0);
        }

    }
/* never gets here.. while loop */
close(sock);
}
