/*
 * chat.c - code for handling simple chat program
 */

#include <stdio.h>
#include <string.h>
#include "network.h"
#include "chat.h"


void
filter_ansi( char message[256] ) {
    int i;
    int j;
    int k;
    char temp[256];

    k = 0;

    for( j = 0; j < 256; j++)
         temp[j] = '\0';

    for( i = 0; i < strlen(message); i++) 
        if( (message[i] > 31 && message[i] < 127) || message[i] == '\n' ) {
            temp[k] = message[i];
            k++;
        }

    strcpy(message, temp);
}

int
parse_message( int user_number, struct user LIST[256], 
               char message[256], int max_user ) {
    int i;
    int j;
    int out = -1;

#ifdef DEBUG
    printf("parse_message: entered\n");
#endif /* DEBUG */

    /*
     * Check if a user is quiting.
     */
    if(!strncmp( message, "/quit", 5 )) {
        close_socket( user_number );
        for( i = 3; i < max_user; i++) 
            if( LIST[i].status == 1) {
                send_data( i, "SYSTEM MESSAGE: User [" );
                send_data( i, LIST[user_number].name );
                send_data( i, "] has left.\n" );
            }
        deactivate_user( user_number, LIST ); 
        out = 1;
    goto done;
    }

    /*
     * Private Messages
     */

    if(!strncmp( message, "/p", 2 ) && message[2] == ' ') {
        /* Find end of user name, cannot exceed 29  */
        for(i = 3; i < 30; i++) 
            if(message[i] == ' ') break;

        /* Check if user name was too long */
        if(i == 29) {
            send_data( user_number, "SYSTEM MESSAGE: no such user\n");
            out = 1;
            goto done;
            }

        /* Find socket that matches user number */
        for(j = 0; j < 256; j++)
            if(!strncmp(message + 3, LIST[j].name, i - 3)) {
                send_data( j, "P[" );
                send_data( j, LIST[user_number].name );
                send_data( j, "]: ");
                send_data( j, message + i + 1);
                send_data( user_number, "P[" );
                send_data( user_number, LIST[user_number].name );
                send_data( user_number, "]: ");
                send_data( user_number, message + i + 1);
                out = 1;
                goto done;
                }
        send_data( user_number, "SYSTEM MESSAGE: no such user\n");
        out = 1;
        goto done;
        }
  
    /*
     * help and stuff
     */
    if(!strncmp( message, "/help", 5)) {
        send_data( user_number, "------Help------\n");
        send_data( user_number, "/who - List who is on\n");
        send_data( user_number, "/name [name] - Change Name\n");
        send_data( user_number, "/quit - Quit the system\n");
        send_data( user_number, "/help - This help screen\n");
        send_data( user_number, 
                         "/p [name] [message] - Send a message to a user\n");
        send_data( user_number, "----------------\n\n");
        out = 1;
        goto done;
    }   

    /* 
     * Check if a user is changing their name
     */
    if(!strncmp(message, "/name", 5) && message[5] == ' ') {
        for( i = 3; i < max_user; i++) 
            if( LIST[i].status == 1) {
                send_data( i, "SYSTEM MESSAGE: User [" );
                send_data( i, LIST[user_number].name );
                send_data( i, "] has changed name to " );
            }

        /* Clear out the name */
        for(i = 0; i < 25; i++)
            LIST[user_number].name[i] = '\0';
        strncpy(LIST[user_number].name, message + 6, 25);
        if(strlen(LIST[user_number].name) < 27)
            LIST[user_number].name[strlen(LIST[user_number].name) - 1] = '\0';
        out = 1;

        for( i = 3; i < max_user; i++) 
            if( LIST[i].status == 1) {
                send_data( i, LIST[user_number].name );
                send_data( i, "\n" );
            }
        goto done;
    }

    if( !strncmp(message, "/who", 4 ) ) {
        send_data( user_number, "------Who's On------\n" );
        for(i = 0; i < 256; i++)
            if(LIST[i].status == 1) {
                send_data( user_number, LIST[i].name );
                send_data( user_number, "\n" );
            }
        send_data( user_number, "--------------------\n\n" );
        out = 1;
        goto done;
    }

    /* Don't know what to do so just display it.. */

#ifdef DEBUG
    printf("Fell through on parse. max_user = %d\n", max_user);
#endif /* DEBUG */

    for( i = 3; i < max_user; i++ ) 

#ifdef DEBUG
    printf("LIST[%d].status = %d\n", i, LIST[i].status);
#endif /* DEBUG */

        if(LIST[i].status == 1) {
            send_data( i, "[" );
            send_data( i, LIST[user_number].name );
            send_data( i, "]: ");
            send_data( i, message);
        }
    out = 1;

done:

#ifdef DEBUG
    printf("parse_message: leaving\n");
#endif /* DEBUG */

    return( out ); 
}

int
initialize_user( int user_number, struct user LIST[256] ) {
    int i;

#ifdef DEBUG
    printf("intialize user: entered\n");
#endif /* DEBUG */

    for( i = 1; i < 25; i++ )
        LIST[user_number].name[i] = '\0';

    LIST[user_number].name[0] = '?';
    LIST[user_number].status = 0;

#ifdef DEBUG
    printf("initialize user: leaving\n");
#endif /* DEBUG */
}

int deactivate_user( int user_number, struct user LIST[256] ) {

#ifdef DEBUG
    printf("deactivate_user: entered\n");
#endif /* DEBUG */

    LIST[user_number].status = 0;

#ifdef DEBUG
    printf("deactivate_user: leaving\n");
#endif /* DEBUG */
}

int activate_user( int user_number, struct user LIST[256] ) {

#ifdef DEBUG
    printf("activate_user: entered\n");
#endif DEBUG

    initialize_user( user_number, LIST );
    LIST[user_number].status = 1;

#ifdef DEBUG
    printf("activate_user: leaving\n");
#endif /* DEBUG */
}


