
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "modify.h"
#include "proto.h"

/*
 * uint remove_letter(char*, uint*)
 *
 * remove first and last letter 
 *
 */

uint remove_letter(char *tmp, uint *count)
{
  uint lengh=strlen(tmp);
  
  if(lengh>=3)
  {
    switch(*count)
    {
      case 0:  /* remove first letter */
        memmove(tmp, tmp+1, lengh);
        return 1;
        break;
        
      case 1:  /* remove last letter */
        tmp[lengh-1]=0;
        return 1;
        break;
    }
  }
  return 0;
} 

/*
 * uint add_signs(char*, uint*);
 *
 * add various signs at the beginning of a word and at the end
 *
 * WARNING! this is a great function but it will loop 76 times
 * so the crack speed will suffer of it
 *
 */

uint add_signs(char *tmp, uint *count)
{
  static char signs[]="1234567890-=!@#$%^&*()_+,./<>?;':{}[]~";
  static uint amount=0;
  uint lengh=strlen(tmp);
  
  if(!amount)  /* do it only once */
    amount=strlen(signs);
  
  if(lengh>7)
    lengh=7;
    
  if(*count<amount)  /* add at the end */
  {
    tmp[lengh]=signs[*count];
    tmp[lengh+1]=0;
    return 1;
  }
  
  else if(*count>=amount && *count-amount<amount)  /* add at beginning */
  {
    memmove(tmp+1, tmp, lengh);
    tmp[0]=signs[*count-amount];
    return 1;
  }
  
  return 0;
}      
      

/*
 * uint mirror(char *tmp, uint *count)
 *
 * copy and reverse the word and append it to the original word
 * Ex.: Fred become FreddreF, and hi become hiih
 *
 */

uint mirror(char *tmp, uint *count)
{
  static uint change;
  uint loop, lengh=strlen(tmp);
  uchar letter;
  
  if(lengh<=4)  /* don't work with words longer than 4 */
  {
    for(loop=0; loop < lengh; loop++)
      tmp[(lengh*2)-1-loop]=tmp[loop];
  
    tmp[lengh*2]=0;
  }
  
  switch(*count)
  {
    case 0:  /* leave it mirrored */
      change=0;
      return 1;
      break;
    
    case 1:  /* change case of middle letters */
      letter=tmp[lengh-1];
      if(letter!=(tmp[lengh-1]=toupper(tmp[lengh-1])))  /* if letter is lower case */
      {
        tmp[lengh]=toupper(tmp[lengh]);
        return 1;
      }
      
      if(letter!=(tmp[lengh-1]=tolower(tmp[lengh-1])))  /* if letter is upper case */
      {
        tmp[lengh]=tolower(tmp[lengh]);
        return 1;
      }
        /* no break! */
     (*count)++;
        
    default:
      loop=change_limit(tmp, &change); 
      change++;
      return loop;
 }
       
 return 0;
}
  

/* 
 * uint change_limit(char*, uint*);
 *
 * if possible, first change case of both first and last letters 
 * and then change case of first letter and after, case of last letter
 *
 */ 

uint change_limit(char *tmp, uint *count)
{
  uint lengh=strlen(tmp);
  char letter;
  
  switch(*count)
  {
    case 0:  /* change both letters */
      letter=tmp[0];
      if(letter!=(tmp[0]=toupper(tmp[0])))  /* if letter is lower case */
      {
        tmp[lengh-1]=toupper(tmp[lengh-1]);
        return 1;
      }
      
      if(letter!=(tmp[0]=tolower(tmp[0])))  /* if letter is upper case */
      {
        tmp[lengh-1]=tolower(tmp[lengh-1]);
        return 1;
      }
      (*count)++;        
      break;
          
    case 1:  /* change only first letter */
      letter=tmp[0];
      
      if(letter!=(tmp[0]=toupper(tmp[0]))) /* if letter is lower case */
        return 1;
        
      if(letter!=(tmp[0]=tolower(tmp[0]))) /* if letter is upper case */
        return 1;
        
      break;
      
    case 2:  /* change only last letter */
      letter=tmp[0];
      if(letter!=(tmp[lengh-1]=toupper(tmp[lengh-1])))  /* if letter is lower case */
        return 1;
        
      if(letter!=(tmp[lengh-1]=tolower(tmp[lengh-1])))  /* if letter is upper case */
        return 1;
        
      break;
  }
  return 0;
  
}


/*
 * uint reverse(char*, uint*);
 *
 * invert order of letters
 *
 * ex.: hello become olleh
 *
 */

uint reverse(char *tmp, uint *count)
{
  uint loop, lengh=strlen(tmp);
  char *buff;
  
  if(lengh <= 2 || *count)  /* do nothing on words <= 2 or if we have already do it*/
    return 0;
  
  buff=(char*)malloc(sizeof(char)*(lengh+1));
  strcpy(buff, tmp);
  
  for(loop=0; loop < lengh; loop++)  /* reverse data */
    tmp[loop]=buff[lengh-loop-1];
  
  if(!strcmp(tmp, buff))  /* if string is symetric... don't test it again */
  {
    free(buff);
    return 0;
  }
  
  free(buff);
  
  *count=!(*count);  /* do it only once */
  
  return *count;
}  
  

/*
 * uint nothing(char*, uint*)
 *
 * do nothing!
 *
 */

uint nothing(char *tmp, uint *count)
{
  *count=!(*count);  
  return *count;
}

uint walking_upper(char *tmp, uint *count)
{
  if(strlen(tmp)<=2)  /* don't work with words smaller than 2 */
    return 0;
  
  tmp+=(*count)+1;  /* don't change first letter because change_limit already done that */
  
  if(*(tmp+1))  /* if word is not finished */
  {
    while(*(tmp+1)) /* don't change last letter because change_limit already done that */
    {
      if((0x61 <= *tmp) && (*tmp <= 0x7a)) 
      {
        *tmp-=0x20;  /* make uppercase */
        return 1;
      }
      else
      {
        tmp++;
        (*count)++;
      }
    }
  }
  
  return 0;
}

uint walking_lower(char *tmp, uint *count)
{
  if(strlen(tmp)==1)
    return 0;
  
  tmp+=(*count)+1;
  
  if(*tmp)  /* if word is not finished */
  {
    while(*(tmp+1))
    {
      if((0x41 <= *tmp) && (*tmp <= 0x5a)) 
      {
        *tmp+=0x20;  /* make lowercase */
        return 1;
      }
      else
      {
        tmp++;
        (*count)++;
      }
    }
  }
  
  return 0;
}  

