/*
 * chain.c
 *
 * version 2.1
 *
 * Ces fonctions travaillent sur des listes chainees simples.
 *
 * By: Olivier Daigle (beagle@mediom.qc.ca)
 * 
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include "chain.h"
#include "message.h"


/*
 * struct Header* new_list(void)
 *
 * Cette fonction cree un nouveau header de liste et renvoie un pointeur
 *   sur ce header. Il initialise les fields de la structure en faisant
 *   pointer 'first' et 'last' sur NULL comme aucun node n'est contenu
 *   dans la chaine. 'longeur' est aussi initialise a 0.
 *
 */

struct Header* new_list(void)
{
  struct Header *nouveau;
  nouveau = (struct Header* ) malloc(sizeof (struct Header));
  if (nouveau)
  {
    nouveau->longeur =0;
    nouveau->first = nouveau->last = NULL;
  }
  else
  {
    message(1);
    exit(2);
  }
  return(nouveau);
}


/*
 * struct Fcb* create_node(struct Header*)
 *
 * Cette fonction cree un nouveau node a la fin de la chaine dont le
 * header est 'list'.
 * Elle fait pointer le field 'last' du header sur le nouveau node
 * et incremente 'longeur'.
 * Si le nouveau node est le premier de la chaine, la fonction fait pointer
 * 'first' du header dessus
 * Elle retourne un pointeur sur le nouveau node cree.
 *
 */

struct Fcb* create_node(list)
struct Header *list;
{
  struct Fcb *nouveau;
  nouveau=(struct Fcb*)malloc(sizeof (struct Fcb));
  if (nouveau)
  {
    nouveau->next = NULL;

    if(list->longeur)  /* S'il y a deja des structs dans list */
    {
      list->last->next=nouveau;
      list->last=nouveau;
    }

    else   /* Si list est vide */
    {
      list->last=nouveau;
      list->first=nouveau;
    }

    list->longeur++;
    init_fcb(nouveau);
  }
  else
  {
    message(1);
    exit(2);
  }
  return (nouveau);
}


/*
 * struct Fcb insert_node(struct Header*, uint)
 *
 * Cette fonction cree un nouveau node dans la chaine dont le header est 'list'
 * a la position pos. Si pos == 0, le node est cree au debut de la chaine et
 * le field 'first' du header 'list' est donc modifie
 * Si pos est plus grand que la longeur de la chaine, le node est cree a la
 * fin de la chaine avec la fonction create_node().
 * Pour les autres valeurs de pos, le field next du node precedant le nouveau
 * node est update pour pointer sur le nouveau node.
 * Dans tous les cas ou la creation du node reussi, le field 'longeur' du header
 * est incremente.
 * La fonction retourne un pointeur sur le nouveau node cree.
 *
 */

struct Fcb* insert_node(list, pos)
struct Header *list;
uint pos;
{
  struct Fcb *tmp, *nouveau;

  if(pos >= list->longeur)   /* si la liste est vide ou si on ajoute plus loin que la fin */
    return (create_node(list));

  tmp=list->first;

  nouveau = (struct Fcb* ) malloc(sizeof (struct Fcb));
  if (nouveau)
  {
    if(pos)
    {
      while(--pos)  /* seek */
        tmp=tmp->next;

      nouveau->next=tmp->next;
      tmp->next=nouveau;
    }

    else  /* si pos =0... insert au debut + change le first field */
    {
      nouveau->next=list->first;
      list->first=nouveau;
    }
  list->longeur++;
  init_fcb(nouveau);
  }

  else
  {
    message(1);
    exit(2);
  }

  return(nouveau);
}


/*
 * void remove_node(struct Header*, uint)
 *
 * Cette fonction efface un node a la position 'pos' d'une chaine dont le
 * header est 'list'.
 * Si pos == 0, le premier node de la chaine est enleve. La fonction fait
 * donc pointer le field 'first' du header 'list' sur le node pointe par
 * le field 'next' du node a enlever.
 * Si le node a enlever se situe a la fin de la chaine, le field 'last' du
 * header est change pour l'adresse de l'avant-dernier node.
 * Le field 'next' du node precedant le node a enlever est change pour le
 * field 'next du node a enlever.
 * Si le field 'longeur' du header == 1, la fonction enleve le seul node de
 * la chaine et fais pointer les fields 'first' et 'last' du header sur NULL
 * car la chaine est maintenant vide.
 * Si le field 'longeur' du header == 0, la fonction retorune 0 et rien n'est
 * change.
 * Dans tous les autres cas, le field 'longeur' du header est decremente.
 *
 */

uchar remove_node(list,pos)
struct Header *list;
uint pos;
{
  struct Fcb *tmp, *old;

  if(list->longeur)
  {
    tmp=list->first;

    if(pos && list->longeur-1)
    {
      while(--pos && tmp->next->next)  /* seek until pos && tmp->next==NULL */
        tmp=tmp->next;

      old=tmp->next;
      tmp->next=tmp->next->next;

      if (!tmp->next)  /* si le dernier element est enleve, list->last doit etre update */
        list->last=tmp;

      tmp=old;

    }
    else if (list->longeur==1) /* premier et seul element */
    {
      tmp=list->first;
      list->first=list->last=NULL;
    }
    else  /* enleve le premier item */
      list->first=list->first->next;

    list->longeur--;
    free(tmp);
    return 1;
  }
  return 0;
}


/*
 * struct Fcb* remove_node_by_addr(struct Header*, struct Fcb*)
 *
 * Cette fonction efface le node pointe par old dans la liste list
 * Elle retourne 0 si l'operation reussit, sinon 1
 *
 */

struct Fcb* remove_node_by_addr(list, old)
struct Header *list;
struct Fcb *old;
{
  struct Fcb *tmp;
  
  if(list->longeur && old)  /* if old == NULL... there's a problem!! */
  {
    for(tmp=list->first; tmp; tmp=tmp->next)  /* seek */
    {
      if(tmp->next == old) /* MATCH!! */
      {
        if(old->next)  /* si c'est pas le dernier element */
        {
          tmp->next=old->next;
          free(old);
          list->longeur--;
          return tmp;
        }
        
        else  /* dernier element */
        {
          list->last=tmp;
          tmp->next=NULL;
          free(old);
          list->longeur--;
          return tmp;
        }
      }
      
      if(tmp == old)  /* premier element de la list == the one to remove */
      {
        list->first=tmp->next;
        free(old);
        list->longeur--;
        return list->first;
      }
    }
  }
       
  return NULL;
}          
          
          
         
    
    

/*
 * void remove_chain(struct Header*)
 *
 * Cette fonction efface tout les nodes d'une chaine ainsi que son header.
 * A l'origine, cette fonction etait plus courte mais demandait plus de CPU
 * pour etre executee:
 *
 *   void remove_chain(list)
 *   struct Header *list;
 *   {
 *     while(remove_node(list,0));
 *     free(list);
 *   }
 *
 * Les fields du header n'ont pas besoin d'etre updates lorsqu'on efface une
 * chaine. La nouvelle fonction prend en consideration cet aspect et est
 * donc plus rapide.
 *
 */

void remove_chain(list)
struct Header *list;
{
  struct Fcb *pos, *tmp;

  pos=list->first;

  while(pos)  /* while pos != NULL */
  {
    tmp=pos->next;
    free(pos);
    pos=tmp;
  }

  free(list);
}

void init_fcb(nouveau)
struct Fcb *nouveau;
{
  nouveau->pw=(struct passwd*)malloc(sizeof(struct passwd));
  nouveau->is_done=0;
  nouveau->salt_done=0;
}

/*
 * chain.c
 *
 * Enf Of File
 *
 */