#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <linux/if_ether.h>
#include <linux/if.h>
#include <time.h>

#include "connect.h"

/* 
 * SynWatch
 *   written by, Jeff Thompson (jwthomp@uiuc.edu)
 *  This program will log all SYNs
 *
 *  This program is a complete hack.  It is not meant as an example of 
 * how to program, let alone cook potatoes.  Use at your own risk, and by
 * god, look both directions before crossing the street.
 */

#define LOG "/var/adm/syn.log"


struct ifreq oldifr, ifr;
struct connection *head;


void 
go(int argc, char *argv[]) {
    int l, i, j;
    int sock, length;
    struct sockaddr_in name;
    unsigned char buf[4096];
    unsigned int feh;
    int size;
    char DEV[255];
    int time = 0;
    int num, choice;
    FILE *fp;
    char *tim;
    time_t t;

    head = NULL;

    if(argc < 2) {
        printf("%s: Ethdevice\n", argv[0]);
        exit(1);
    }

    /* 
     * Obtain ip and port from command line
     */
    strcpy(DEV, argv[1]);

    /* 
     * Get a socket which will collect all packets
     */
    sock = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL));

    if (sock < 0) {
        printf("Cannot open Raw Socket.\n");
        exit(1);
    }

    /* 
     * Configure ethernet device
     */
    strcpy(ifr.ifr_name, DEV);
    strcpy(oldifr.ifr_name, DEV);

    /*
     * Get flags and place them in ifr structure
     */
    if(ioctl(sock, SIOCGIFFLAGS, &ifr) < 0) {
        printf("Unable to get %s flags\n", DEV);
        exit(1);
    }

    /*
     * Get flags and place them in oldifr structure
     *   This will be used later to change ether device characteristics back
     *   to their original value
     */
    if(ioctl(sock, SIOCGIFFLAGS, &oldifr) < 0) {
        printf("Unable to get %s flags\n", DEV);
        exit(1);
    }

    /*
     * Set the promiscous flag
     */
    ifr.ifr_flags |= IFF_PROMISC;

    /*
     * Set the device flags
     */
    if(ioctl(sock, SIOCSIFFLAGS, &ifr) < 0) {
        printf("Unable to set %s flags\n", DEV);
        exit(1);
    } 

    /*
     * Set up sockaddr
     */
    name.sin_family = AF_INET;
    name.sin_addr.s_addr = INADDR_ANY;
    name.sin_port = 0;

    length = sizeof(name);

    if (getsockname(sock, (struct sockaddr *) &name, &length) < 0) {
        printf("Error: Can't get socket name\n");
        exit(1);
    }

    printf("SYN Watch started\n");
    feh = sizeof(struct sockaddr);

    /*
     * Entering the data collection loop
     */
    for( ; ; ) {
        if ((l = recvfrom(sock, buf, 1024, 0, (struct sockaddr *)&name, 
                      &feh)) < 0)
            printf("Error receiving RAW packet\n");


        /* 
         * Check to make sure this is an IP packet
         *  The number starts high as the ethernet frame is in the buffer as well.
         */
        if(buf[14] == 0x45 || buf[14] == 0x54) {
            /*
             * Verify that it is protocol 6 & type is SYN.
             */
            if(buf[23] == 6 && buf[47] == 0x02) {
                fp = fopen(LOG, "a+");
                tim = ctime(&t);
                tim[strlen(tim) - 6] = '\0';

               fprintf(fp, "%s: SYN Received: saddr:%d.%d.%d.%d daddr: %d.%d.%d.%d ",
               tim, buf[26] & 0xff, buf[27] & 0xff, buf[28] & 0xff, buf[29] & 0xff,
               buf[30] & 0xff, buf[31] & 0xff, buf[32] & 0xff, buf[33] & 0xff);
               fprintf(fp, "sport: %d dport: %d\n", 
                     (buf[34] & 0xff) * 256 + buf[35] & 0xff, 
                     (buf[36] & 0xff) * 256 +  buf[37] & 0xff);
              fclose(fp);
            }
        }

    }

close(sock);
exit(0);
}

void main(int argc, char *argv[])
  {
  go(argc, argv);
  }

