#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <linux/if_ether.h>
#include <linux/if.h>
#include "find.h"
#include "connect.h"

/* 
 * Lister
 *   written by, Jeff Thompson (jwthomp@uiuc.edu)
 *  This program will list all ongoing connections
 */


struct ifreq oldifr, ifr;
struct connection *head;


void 
go(int argc, char *argv[])
{
int l, i, j;
int sock, length;
struct sockaddr_in name;
unsigned char buf[4096];
unsigned int feh;
int size;
char DEV[255];
int timeout;
int time = 0;
int num, choice;
head = NULL;

if(argc < 3)
  {
  printf("%s: Ethdevice Timeout\n", argv[0]);
  exit(1);
  }

/* 
 * Obtain ip and port from command line
 */
strcpy(DEV, argv[1]);
timeout = atoi(argv[2]);

/* 
 * Get a socket which will collect all packets
 */
sock = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL));

if (sock < 0) 
    {
    printf("Cannot open Raw ICMP Socket.\n");
    exit(1);
    }

/* 
 * Configure ethernet device
 */
strcpy(ifr.ifr_name, DEV);
strcpy(oldifr.ifr_name, DEV);

/*
 * Get flags and place them in ifr structure
 */
if(ioctl(sock, SIOCGIFFLAGS, &ifr) < 0)
  {
  printf("Unable to get %s flags\n", DEV);
  exit(1);
  }

/*
 * Get flags and place them in oldifr structure
 *   This will be used later to change ether device characteristics back
 *   to their original value
 */
if(ioctl(sock, SIOCGIFFLAGS, &oldifr) < 0)
  {
  printf("Unable to get %s flags\n", DEV);
  exit(1);
  }

/*
 * Set the promiscous flag
 */
ifr.ifr_flags |= IFF_PROMISC;

/*
 * Set the device flags
 */
if(ioctl(sock, SIOCSIFFLAGS, &ifr) < 0)
  {
  printf("Unable to set %s flags\n", DEV);
  exit(1);
  } 

/*
 * Set up sockaddr
 */
name.sin_family = AF_INET;
name.sin_addr.s_addr = INADDR_ANY;
name.sin_port = 0;

length = sizeof(name);

if (getsockname(sock, (struct sockaddr *) &name, &length) < 0)
    {
    printf("Error: Can't get socket name\n");
    exit(1);
    }

printf("Up and running. Collect them NFO'Z\n");
feh = sizeof(struct sockaddr);

/*
 * Entering the data collection loop
 */
for( ; ; )
    {
    if ((l = recvfrom(sock, buf, 1024, 0, (struct sockaddr *)&name, 
                      &feh)) < 0)
        printf("Error receiving ICMP packet\n");


/* 
 * Check to make sure this is an IP packet
 *  The number starts high as the ethernet frame is in the buffer as well.
 */
if(buf[14] == 0x45 || buf[14] == 0x54) 
  /*
   * Verify that it is protocol 6.
   */
  if(buf[23] == 6)
    {
    if(newconnection(buf, head))
      head = addconnection(buf, head); 

    time++;
    }
if(time >= timeout)
  {
  num = printconnections(head);
  time = 0;
  printf("Found %d unique connections.\n", num);
  break;
  }

fflush(stdout);


    }

close(sock);
exit(0);
}

void main(int argc, char *argv[])
  {
  go(argc, argv);
  }

