#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "checkconfig.c,v 1.1.1.1 1995/06/16 21:10:53 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Perform basic brimstone parse to check for syntax errors
 */

#include "interface.h"
#include "readconf.h"



int
main(int argc,char *argv[])
{
  int c, errflg = 0;
  extern char *optarg;
  extern int optind;
  int verbose = 0;
  char *configfile = NULL;

  while ((c = getopt(argc, argv, "dC:v")) != -1)
    switch (c)
      {
      case 'd':
	bs_debug++;
	break;
      case 'C':
	configfile = optarg;
	break;
      case 'v':
	verbose++;
	break;
      case '?':
        errflg++;
      }

  if (errflg)
    {
      fprintf(stderr,"Usage: %s [-dv] [-C config]\n",argv[0]);
      exit(5);
    }

  if (readconfig(configfile) != AUTH_SUCCEED)
    {
      fprintf(stderr,"Failed");
      if (verbose)
	{
	  fprintf(stderr,":  %s\n",bs_auth_extended);
	}
      fprintf(stderr,"\n");
      exit(5);
    }

  printf("\nConfiguration Good!\n\n");
  exit (0);
}
